// ---------------------------------------------------------------------------
// Edit this file to define your game. It should have at least four
// sets of content: undum.game.situations, undum.game.start,
// undum.game.qualities, and undum.game.init.
// ---------------------------------------------------------------------------



  Array.prototype.shuffle = function() {
var s = [];
while (this.length) s.push(this.splice(Math.random() * this.length, 1)[0]);
while (s.length) this.push(s.pop());
return this;
}

/* tracking with the first story as well */

  var _gaq = _gaq || [];
  _gaq.push(['_setAccount', 'UA-38641917-1']);
  _gaq.push(['_trackPageview']);

  (function() {
    var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
    ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
  })();



/* A unique id for your game. This is never displayed. I use a UUID,
 * but you can use anything that is guaranteed unique (a URL you own,
 * or a variation on your email address, for example). */
undum.game.id = "markmarinocomstorybook3";

/* A string indicating what version of the game this is. Versions are
 * used to control saved-games. If you change the content of a game,
 * the saved games are unlikely to work. Changing this version number
 * prevents Undum from trying to load the saved-game and crashing. */
undum.game.version = "1.8";


/* The situations that the game can be in. Each has a unique ID. */
undum.game.situations = {};

undum.game.situations['start'] = new undum.SimpleSituation(
	"<p>And then [hack, hack] Oh, excuse me [hack, hack, cough, retch, hack, retch]. </p>",
	 {  
	   enter: function(character, system, from) {
			var hacktext=["<br/>[hack, hack, hack]\
                          <h1>The Lady of the Primrose</h1>\
						  <p>Surely, to be a lady in waiting was a far greater trial than to be a noble night.  Yay, verily, the good Sir Edward did vanquish the Nottingham Knight with a single blow of his two-handed blade.</p>\
						  <p>But it was Maid Lady Margaret who had to sit, in the solemn stillness of the tower, weaving rose petals into grocery bags, while she awaited the tardy titan.</p>\
							",
							"<br/>[burrrrrp]\
							<h1>The Monster Knocks Twice</h1>\
						  <p>Janey was not one to notice noises when she slept.  No, with her mouth, wide like a cave, and drool spilling from her lips into a puddle, like a small lake, beside her matted hair, Janey was dead to the world. So it was a surprise that she heard the knock at all.</p>\
						  ",
							"<br/>[cooough-ka]\
							<h1>Nutty Raisin Mezcla</h1>\
						  <p>2 cups of parsley, chopped fine\
						  <br/>3 cups of raisins, swirled\
						  <br/>4 tablespoons of tamale juice\
						  <p>Take the parsley and shake it.  Really shake it. Shake some sense into it. Then when it's not looking, toss a handful of raisins at it and duck under the counter where it can't see you.</p>",
						    "<br/>[Ahhhh-shoes]\
							<h1>If Upon a Winter's Night a ...</h1>\
							<p>Calvin was out of both size-eight shoes and ideas, and he had been since 1984. It was 1996. Out of ideas, that is.  The size eights had only recently sold out.</p>\
							<p>At last he cried, 'I've got it!' and rising suddenly, he knocked over a stack of shoe boxes. 'What if we tell a story just of beginnings?'</p>\
							<p>The woman to whom he was apparently speaking gave him a slight smile before asking politely, 'Do you have this in a seven and a half?'</p>",
						"<br/>[huzzzah]\
							<h1>The Hangry Games</h1>\
							<p>Jenna was fast.  But she was also hungry.  And ANGRY.</p>\
							<p>She was hangry.</p>\
							<p>And when she was like that, you did not want to get in her way.</p>\
							<p>They had created the Hangry Games to see who could get the crabbiest when deprived of food, especially cereal.  And Jenna was ready to rage.  She loved cereal! So her little sister did not know what she was walking into when she entered the kitchen and said, 'I think we're out of milk.'</p>",
						"<br/>[blagggarrgh]\
							<h1>The Lightning Teeth</h1>\
							<P>Could it be? Could Jake really be the son of a Greek God? Molarus, God of Dentistry?</p>\
							<p>'Doc says we're going to have to pull this one,' said the dental hygienist through her mask.</p>\
							<p>Jake's head was spinning. 'But, but, this must mean I'm also a god,' said Jake to himself.</p>\
							<p>'Oh, wow,' she replied unimpressed. 'Then, why didn't you floss more?'</p>\
							<p>'Cuz,' said Jake opening a mouth full of flashes and sparks, 'Lightning Teeth!'</p>\
							",
							"<br/>[cu-cu-ca-chooey]\
							<h1>Silicon Valley High</h1>\
							<p>'It's worse than we thought,' said Mother holding up the letter from the doctor.</p>\
							<p>'Don't tell me,' said Father. 'She'll never become a computer programmer?</p>\
							<p>'Worse,' whispered Mother.</p>\
							<p>'What could be worse?'</p>\
							<p>'It says our daughter has become...,' Mother could barely choke back the tears, 'BOY CRAZY!'</p>",
							"<br/>[caw-wuf]\
							<br/><strong>Santa Ana. n.</strong> Winds that blow in from the coast of Los Angeles, mostly during the fall and winter.\
							<br/><strong>Santana. n.,</strong> A supernatural force which blows things apart that are meant to be together, incl. people, pages, hopes and dreams. The enemy of the Book of the Lost.  The nemesis of Mrs. Wo...</p>",
							"<br/>[gag-like-gag]\
							<h1>Nightlight</h1>\
							<p>'I love you, too,' said Ted, 'But you know I'm a vampire.'</p>\
							<p>'I know!' Della spat back, bursting into tears.</p>\
							<p>'And I would do anything for you.' If only he could make her believe him.</p>\
							<p>'But, then, why? Why?' she said, turning to face him, bravely.</p>\
							<p>'Why what?' he asked, moving closer, his pale skin almost glowing.</p>\
							<p>'Why won't you ever take me to the beach?' she replied.</p>"
							];
			var choose=system.rnd.randomInt(0,8);
			system.write("<p><em>"+hacktext[choose]+"</em></p><br/>");
			system.write("<p>[Cough, cough.]</p><p>Sorry.  <a href='./switchpageball' class='once'>Pageball</a>.</p>\
			<p>That's been happening a bit more frequently these days.  Not sure why.  But here I'll just try a lozenge or something. There.</p>\
			<p class='transient'>Okay, now where would you like to go next?</p>\
			<ul class='options'>\
			<li><a href='switchstart' onClick='_gaq.push([\"_trackEvent\",  \"Switcheroo\", \"GameorStory\", \"Story\"]);'>I'd like to read the Story</a></li>\
			<li><a href='switchdollgame' onClick='_gaq.push([\"_trackEvent\",  \"Switcheroo\", \"GameorStory\", \"Game\"]);'>Forget the Story, let me play the Card Game</a></li>\
	</ul>");
			//system.writeSound(character, 'switchhack');
			},
		actions: {
			'switchpageball': function(character, system, action) {
			system.write("<p>Oh, Pageballs are like the fur balls your kitty cat hacks up -- only these appear to be pages from other books that seem to have gotten mixed up in my binding.</p>");
			system.animateQuality(
				'page', character.qualities.page + 1
				);
			}
		
		}
	}
);


undum.game.situations['switchstart'] = new undum.SimpleSituation(
	"",
	 {  
	   enter: function(character, system, from) {
	   character.sandbox.name=system.getName();
		system.write("<p>Wonderful. Welcome back, " + character.sandbox.name + " (if that is, in fact, your name.</p>\
		<p>Now don't forget to hunt for the poem hidden in the pages. That'll give you a Poetry Power-Up! But wait -- are you up to speed?  Have we met yet? Do you know who I am?  Do you know what you're reading?</p>\
		<ul class='options'>\
		<li><a href='switchsplain'>What am I reading? What are you talking about? Why are you talking to me?</a></li>\
		<li><a href='switchstarta'>Yes, yes, I know all of this already. I've read the other stories.</a></li></ul>");
	}
	}
);



undum.game.situations['switchsplain'] = new undum.SimpleSituation(
	"<p>Ah, well, welcome.  I am the Book of the Lost, a living book and holder of the tales of Mrs. Wobbles and the Tangerine House. If you've not yet read them, I highly recommend them.</p>\
	<p>Mrs. Wobbles is the kindly <a href='./switchfoster'>foster mom</a> who runs and owns the Tangerine House. She may or may not be a witch, but you can decide that for yourself.  What would you like to read first?  I should warn you that clicking on the previous stories will take you out of this episode.  You can, of course, always come back.</p>\
	<ul class='options'>\
	<li><a href='http://markcmarino.com/tales/storybook3.html'>Book 1: The Mysterious Floor</a></li>\
	<li><a href='http://markcmarino.com/tales/storybook2wobbles.html'>Book 2: Parrot the Pirate</a></li>\
	<li><a href='switchstart1'>Book 3: Switcheroo (continue, please)</a></li>\
	</ul>",
	{
	actions: {
            'switchfoster' : function(character, system, action){
			system.write("<p>Foster care homes are places that care for children whose mothers or fathers can't raise them for one reason or another.  Children may be adopted from foster care or might grow up to adults in it. You might even know some foster children. If not, you should. They are wonderful! </p>");
			}
		}
	}
);

undum.game.situations['switchstarta'] = new undum.SimpleSituation(
    "<p>All right. Yes. Right. I thought you looked familiar. Let's get on with this, <a href='switchstart1'>shall we?</a></p>"
);
	
undum.game.situations['switchstart1'] = new undum.SimpleSituation(
	"<center><img src='media/games/tutorial/images/switcherooheader350.png'></center>\
	<h1>Switcheroo</h1>\
	<p>The first thing Derik saw when he opened his eyes in his bedroom on the first floor of the Tangerine House was the big basketball on his L.A. Lakers pillowcase, but since he had to use the bathroom something fierce, checking in with his crew on the posters that hung all over his walls --  Tony Hawk, Shaun White and the rest of the sports gods --  would just have to wait.</p>\
	<p>Sometimes a guy's gotta go, you know?</p>\
	<p>So before his eyes were even all the way open, he was heading down the hall on the way <a href='switchintro' class='transient'>to the bathroom.</a> </p>"
);
	
	
	
	
undum.game.situations['switchintro'] = new undum.SimpleSituation(

	"<p>Now just because this story is about to go into the bathroom, doesn't mean it will be going down the toilet, so behave yourself <a href='switchintro1'>and listen.</a></p>" 
	);

undum.game.situations['switchintro1'] = new undum.SimpleSituation(
	"<p>Eyes still half-closed, the next thing he knew he was standing over the potty letting loose.</p>\
	<p>Whizz.</p>\
	<p>No, that wasn't the sound, was it?</p>\
	<p>Trickle, splash.</p>\
	<p>Hmm.  Something was wrong.  <a href='switchintro2'>Something was warm.</a></p>"
	);

undum.game.situations['switchintro2'] = new undum.SimpleSituation(
	"<p>It was then, with the wash of warm pee down his legs, that he realized something was not going according to plan.  For it appeared that at some point in the middle of the night, unexpectedly and unbelievably, his body had transformed from a boy's into a girl's.</p>\
	<p>'Uh, oh,' he said, <a href='switchintro3'>thinking it a dream.</a></p>"
	);
	
undum.game.situations['switchintro3'] = new undum.SimpleSituation(
	"<p>Strangely, the thought that pressed most upon him was, 'I'm going to have to buy new underwear.'  But that uncomfortable feeling of wet socks was soon overtaken by the electric shock that he was not in fact dreaming.</p>\
	<p>'Yoopers!'</p>\
	<p>As he looked down, he saw the puddle at his feet and, well, on his clothes and all.  Yes, <a href='switchintro4'>undeniably a girl.</a></p>"
	);
	
	
undum.game.situations['switchintro4'] = new undum.SimpleSituation(
	"<p>Now, let me just stop us right here, in the bathroom, as Derik stood there in shock, and say that this story will not go into detail about what it might mean for a boy to become a girl.  There'll be no descriptions of body parts or unmentionables or anything like that.  That's why they call them unmentionables.  If you have specific questions, <a href='switchintro5'>ask your parents.</a></p>"
	);
	
undum.game.situations['switchintro5'] = new undum.SimpleSituation(
	"<p>To be honest, he didn't feel any different, physically, but his emotions were spinning like a kaleidoscope.  Sure, he had thought about what it might be like to be a girl before.  What boy hadn't?  Though he had no sisters, he had friends who were girls, and they were perfectly normal, as girls go.  But they clearly were <em>different</em>, and that was as <a href='switchintro6'>it should be.</a></p>"
	);
	
undum.game.situations['switchintro6'] = new undum.SimpleSituation(
	"<p>Oh, and there was that one time he had to wear a princess dress in a performance of the <em>Princess and the Pea</em> at school because the lead girl had come down with the flu, upchucking all over the royal blue sheets and bedspread, which still smelled pretty rank even when Derik performed the part.  But that was only a joke. Make believe.  No, this was strange.  His head <a href='switchintro7'>was swimming.</p>"
	);
	
undum.game.situations['switchintro7'] = new undum.SimpleSituation(
	"<p>As he wiped up the mess (gross because his pee still smelled like pee, not roses as he had always suspected girl pee to smell) and washed his hands, he began trying to figure out what it would mean if this were not a dream.  Of course, he tried the usual: pinching himself, slapping his own cheeks, shaking his head, but he did not wake up. Not even when he stepped on his own toes. Ouch!</p>\
	<p>And then <a href='switchintro8'>it hit him!</a></p>"  
	);

undum.game.situations['switchintro8'] = new undum.SimpleSituation(
	"<p>How did he get to the bathroom?</p>\
	<p>Yoopers!</p>\
	<p>Peeking out, back at his room, he could see through the still-open door of the bedroom, the metal arm of his wheelchair, right where he had parked it last night beside his bed.  And what's more, he was standing! On his own legs! No braces, no nothing!  Though his legs looked somehow -- well, girly --  they were healthy, working, girly legs!</p>\
	<p>Ka-klomp.</p>\
	<p>A sound from one of the bedrooms brought him out of his stupor, and he quickly shut the bathroom door.  Soon, a few hurried steps down the hallway followed by some knocking, which he let go for a few sets.  Then a voice:</p>\
	<p><a href='switchintro9'>'Hey, who's in there?'</a></p>"
	);
	
undum.game.situations['switchintro9'] = new undum.SimpleSituation(
	"<p>His heart was doing jumping jacks.  Woh, maybe he could do jumping jacks! Maybe that would switch him back.  Don't laugh.  What would you do?</p>\
	<p>'Hurry up, please, I really need to go,' came the voice, accompanied by some gotta-go tap dancing.  Then, 'Hey, are you doing jumping jacks in there?'</p>\
	<p>And he was.  Derik, or Darlene, or whatever his girl name would be, was doing jumping jacks.</p>\
	<p>'Come on!  I gotta go. Now! Please!'</p>\
	<p class='transient'>What should Derik say?</p>\
	<ul class='options'>\
	<li><a href='switchanswer1'> Okay, I'll be right out.  Sorry.  Just give me a minute.</a></li>\
		<li><a href='switchanswer2'>Um, I have really bad diarrhea.</a></li>\
		<li><a href='switchanswer3'>Have you ever taken a good look at Mrs. Wobbles' bathroom fixtures?</a></li>\
		</ul>"
		);
		
undum.game.situations['switchanswer1'] = new undum.SimpleSituation(
	"<p>He had to say something.  'Okay, I'll be right out.   Sorry.  Just give me a minute.'  His voice was not his  own raspy voice but a high, tinkly one.  Strange.  Then, after a minute and some further knocking, he added, 'This is -- um -- taking longer than I thought. Sorry. Do you think you could use one of the upstairs bathrooms?'</p>\
	<p>'Okay, no problem,' the voice replied, followed by feet quickly padding <a href='switchbathroom'>up the stairs.</a></p>",
	{
	 enter: function(character, system, from) {
	 				 if (character.qualities.gender<5){
			     system.setQuality("gender", character.qualities.gender + 1);
				 }
				 system.write("<p class='transient'><em>That response was a good cover. Not so pushy.</em></p>");
            } 
	}
 );
	
undum.game.situations['switchanswer2'] = new undum.SimpleSituation(
	"<p>'Ooooh.  I've got some major diarrhea,' Derik said, making squishy fart noises with his mouth and slashing some water from the sink in the toilet for sound effects.</p>\
	<p>'Groooooosssss. I'll just go use the one upstairs,' said the voice, followed by quick footsteps down the hallway and then <a href='switchbathroom'>up the stairs.</a> \
	</p>",
	{
	 enter: function(character, system, from) {
	 				 if (character.qualities.gender>-6){
			     system.setQuality("gender", character.qualities.gender + -1);
				 }
				 system.write("<p class='transient'>Well, that was a very unladylike thing to say!");
            } 
	}
 );
	
undum.game.situations['switchanswer3'] = new undum.SimpleSituation(
	"<p>What would a girl know about? That's it! Decorating, thought Derik, and said, 'Have you ever taken a good look at Mrs. Wobbles' bathroom fixtures?'</p>\
	<p>'What are you even talking about?' said the frustrated voice. 'Mrs. Wobbles has excellent taste in fixtures, and I'm going to pee my pants, thank you very not.' And then that was that. The girl pounded up the stairs to the other bathroom <a href='switchbathroom'>in time, hopefully.</a></p>",
	{
	 enter: function(character, system, from) {
	 				 if (character.qualities.gender<4){
			     system.setQuality("gender", character.qualities.gender + 2);
				 }
				 system.write("<p class='transient'><em>That sounded like something a precocious girl would say. And by precocious I mean trying to act older than she is.</em></p>");
            } 
	}
 );
 
 
 undum.game.situations['switchbathroom'] = new undum.SimpleSituation(
		"<br/><em><p>Oh, that reminds me -- You've no doubt noticed a new category on the Character chart.  For this story, I'll be rating your decisions on this scale to see if you're behaving more toward the rough side, like Huck Finn, or toward the refined and delicate side, like Sleeping Beauty.</p>\
		<p>(Yes, this <a href='./arbitrary' class='once'>arbitrary scale</a> is made up of characters from books. What else would you expect from me?)</p>\
		<p>Each decision will move you a step one way or another on the scale, so the overall impression <a href='switchbathroom1'>builds over time.</a></p></em><br/>",
        { actions: {
		'arbitrary': function(character, system, action) {
		system.write("<p><em>Ah, arbitrary means that there's no real reason for the way things are.  As with any scale we use to judge other people, I just made it up.</em></p><br/>");
		system.animateQuality(
				'page', character.qualities.page + 1
				);
				}
			}
		}
);

undum.game.situations['switchbathroom1'] = new undum.SimpleSituation(	
	"<p>Breathing a bit easier, Derik stepped slowly over to the mirror and took a look at his face.</p>\
	<p>This was even weirder.  In the mirror, his face looked the same as it always did.  But out of the corners of his eyes he could see that where he was standing -- what you and I might call <strong>reality</strong> -- things were different.</p>\
	<center><img src='media/games/tutorial/images/mirror_bg440.png'></center>\
	<p>For one, around the edges of his eyes, he could see curling, <a href='switchbathroom1a'>longer eyelashes.</a></p>"  
	);
	
undum.game.situations['switchbathroom1a'] = new undum.SimpleSituation(	
	"<p>Second, he couldn't see the tip of his nose anymore.  The girl one must be shorter.  But the biggest difference -- and this he could even pull away from his head to see -- was longer hair, almost reaching his shoulders.</p>\  <p>Did girls' hair grow overnight like that?  How did they ever keep it cut?</p>\
	<p>These were his thoughts, not mine. Boys and girls come up with some pretty strange theories <a href='switchbathroom2'>about one another.</a><p>"
	);	
/*	Rather than seeing his own face with lipstick or long eyelashes, as he imagined he might, he found himself staring at a completely different girl's face, not un-pretty, with long brown hair, rather than his usual bowl cut.</p>\
	<p>With his new longer, thinner girl fingers, he made a quick round of all his features, little nose, big blue eyes, fuller lips, and then began making faces at himself to be sure it was in fact him and not some sort of window into another room or trick mirror.</p>\*/
	
	
undum.game.situations['switchbathroom2'] = new undum.SimpleSituation(	
	"<p>Thoroughly convinced this was his body, having pinched and poked just about every inch, he turned to listen at the door again.  Just the sighing of the old house with the wind outside.  Convinced that no one was there, he quietly cracked the door open and surveyed the hall.  A book-sized patch of light was coming in through the shade of the hallway window.</p>\
	<p>Yoopers, morning!  Fortunately, the other children had not yet begun to stir.  The choices were clear:</p>\
	<ul class='options'>\
		<li><a href='switchrundown'>Run down the hall?</a></li>\
		<li><a href='switchwaitbath'>Wait in the bathroom?</a></li>\
	</ul>"
	);

// Don't forget to add some sense of him being able to walk to the end of this	
/* undum.game.situations['switchwaitbath'] = new undum.SimpleSituation(	
	"<p>Derik was frozen.  What if someone saw him -- or really her -- as he -- or really she ran down the hallway? It wasn't worth the risk.  So she just stood there in fright.</p>\
	<p>Of course, eventually she got a little bored. She tried making faces with her new face. But it wasn't very interesting since she couldn't really see her new face.  She saw Derik in the mirror and only caught slight differences out of the corner of her eyes.  However, upon opening a drawer, she came a cross a truly bizarre item.</p>",
	{
	 enter: function(character, system, from) {
			     system.setQuality("gender", character.qualities.gender +1);
				 system.write("<p class='transient'>That sounds like girlish behavior because the boy in Derik would've wanted to run!</p>");
            } 
	}
 );
	*/
	
undum.game.situations['switchwaitbath'] = new undum.SimpleSituation(	
	"<p>She decided to stay in the bathroom. Hiding. Well, she did not want to think that she was hiding, so she began to explore to the bathroom.  Nothing wrong with exploring.  Look at Nancy Drew.  Or Dora.  They were girls and they explored.  She began by opening the drawers of the vanity.</p>\
	<p>In the top drawer, she found: 1 brush, 1 comb, and 1 giant plastic clip, almost half the size of his girlish hand.  The clip resembled one of those little ones he had seen in girls' hair, but this was GIANT. It was more like a brown plastic claw or like two bony hands praying.   What could he do with this device?</p>\
	<ul class='options'>\
		<li><a href='switchshirtclip'>Use the clip to style and cinch his shirt.</a></li>\
		<li><a href='switchponytailhold'>Use the clip to hold his pony tail.</a></li>\
		<li><a href='switchpuppetshow'>Use the clip as a piranha in a puppet show.</a></li>\
		</ul>"
 );	
	
undum.game.situations['switchshirtclip'] = new undum.SimpleSituation(	
	"<p>Well, if he was going to be a girl, might as well try his hand at girls' fashion.  He noticed that by placing the clip at different points on his pajama shirt, he could give it different shapes.  Wide at the belly. Narrow at the waste.  Hour glassy.  But then suddenly he stopped.  What if this was strange? He'd be known as shirt-clip girl or clippy or weird clippy girl?  Man, it was <a href='switchjaredmonth'>hard to be a girl!</a></p>",
	{
	 enter: function(character, system, from) {
	 				 if (character.qualities.gender>-6){
			     system.setQuality("gender", character.qualities.gender -1);
				 }
				 system.write("<p class='transient'><em>Hmm, strange clips, fashion, how are you supposed to know these things anyway?</em></p>");
            } 
	}
 );

undum.game.situations['switchponytailhold'] = new undum.SimpleSituation(	
	"<p>After several unsuccessful attempts at wrangling his hair back, he finally made a respectable pony tail and closed the jaws of the clip around the part closest to his head.  Bingo!  Maybe she had a knack for this <a href='switchjaredmonth'>sort of thing.</a></p>",
	{
	 enter: function(character, system, from) {
	 				 if (character.qualities.gender<4){
			     system.setQuality("gender", character.qualities.gender +1);
				 }
				 system.write("<p class='transient'><em>Ah, you seem to know your way around a hair clip!<em></p>");
            } 
	}
 );

undum.game.situations['switchpuppetshow'] = new undum.SimpleSituation(	
	"<p class='transient'>Hmm, that was not a very fashionable choice.</p>\
	<p>'Hello, I'm Mr. Piranha,' he said in the voice of the puppet clip. 'I like to bite little girls' fingers. Woh? What's this?' Then he made the clip sniff around his other hand.</p>\
	<p>'Smells like boogers. Have you been picking someone's nose?'</p>\
	<p>His other hand nodded.</p>\
	<p>And then he caught sight of himself in the mirror and thought, 'Hmm, great.  Now I'm not only a girl. I'm a strange girl.' <a href='switchjaredmonth'>And he sighed.</a></p>",
	{
	 enter: function(character, system, from) {
	 				 if (character.qualities.gender>-5){
			     system.setQuality("gender", character.qualities.gender -2);
				 }
            } 
	}
 );
	
//Then she tried painting her nails with some polish she found hidden in a drawer.  Actually, there were two bottles, one was a bright cherry red and the other a clear bottle. Why would anyone use invisible polish? wondered Derik. And there was a mysterious stick? Thin and plastic with a sharp-ish edge. What did this have to do with anything?</p>\ <p>Derik decided these must all go together.  Which should he/she try?</p>


/* <ul class='options'>\
		<li><a href='switchstickpick'>Use the stick to pick his nose.</a></li>\
		<li><a href='switchstickshove'>Use the stick to shove at the skin on the bottom of his nails</a></li>\
		<li><a href='switchstickpaint'>Use the stick as a paint sword to draw big Xs on nails like a pirate map.</a></li>\
		</ul> */
	
	
	undum.game.situations['switchstickpick'] = new undum.SimpleSituation(
	"<p>From the moment Derik inserted the stick, he knew it was a bad idea.  It was just too sharp an implement.  And you know what happens when you shove sharp things up your nose.  They pierce your brain and your head deflates. Please do not try this.</p>\
	<p>Fortunately, Derik had not picked or blown his nose for several weeks. To describe the thick, gooey boulders that protected Derik's brain would just be too gross for my delicate sensibilities, so I shall skip over it.  Suffice it to say, Derik's life was saved by a nose <a href='switchjaredmonth'>full of boogers.</a></p>"
	);
	
	undum.game.situations['switchstickshove'] = new undum.SimpleSituation(
	"<p>Something about the stick seemed familiar to Derik.  She vaguely remembered having seen one of his caretakers use it to shove down the thin skin at the base of his nail.  You probably already know that it's called your cuticle, and indeed this was a good way to keep healthy nails before <a href='switchjaredmonth'>painting them.</a></p>"
	);
	
	undum.game.situations['switchstickpaint'] = new undum.SimpleSituation(
	"<p>Perhaps this is how pirates paint their nails.  (But I certainly hope not.)  By the time he was done, he looked like a girl who had put her nails in a blender.  Oh, no, that's too gross. Let's just say his nails were a complete mess, not to mention that he had gotten nail polish all over the counter.  When Mrs. Wobbles saw this he would not have to worry about being a girl anymore.  <a href='switchjaredmonth'>He would be turned into a mosquito.</a></p>"
	);
	
	undum.game.situations['switchjaredmonth'] = new undum.SimpleSituation(
	"<p>Fortunately, today was the day of Jared's monthly shower. </p>\
	<p>Jared was a resident of the Tangerine House who, to put it mildly, did not like showers. He preferred to let his stink stack up around him like a protective bubble.  Getting Jared into the shower took a little work.  Nagila, the giant and otherwise gentle house social worker, and several of the older boys would grab Jared by the arms and drag him in, soaking the entire bathroom in the process.  That was usually attended by quite a crowd.  As expected the commotion was more than enough to get Derik out of the bathroom unseen, though not before he exchanged a curious look with a desperate and <a href='switchregainbreath2'>smelly Jared.</a><p>"
	);
	
// think about the above link or to choosing clothes?
	
undum.game.situations['switchrundown'] = new undum.SimpleSituation(	
	"<p>Without wasting a second, he made a mad dash into his room, slamming the door behind him, and collapsed into the wheelchair.</p>\
	<p>Wow, running! When was the last time he had done that?  Never at his grandmother's house, where he had lived before coming to Mrs.  Wobbles'.  Could he remember <a href='switchregainbreath'>ever running?</a></p>",
	{
	 enter: function(character, system, from) {
			     system.setQuality("gender", character.qualities.gender -1);
            } 
	}
 );

undum.game.situations['switchregainbreath'] = new undum.SimpleSituation(		
	"<p>It was only once he had regained his breath that he began to fully consider the implications of his new situation.  A girl.  Being a girl.  This was so weird.  And although he had once watched a TV show about a boy who could become a girl and then change back again, he was fairly certain that this was unusual, if not impossible, without some sort of major surgery.  But how?  What could <a href='switchmindfilled'>possibly have happened?</a></p>"
);

undum.game.situations['switchmindfilled'] = new undum.SimpleSituation(	
	"<p>His mind filled with strange scenes:<br>\
	Trying to get dressed as a girl in the boys' locker room.  <br>\
	Trying to get dressed as a girl in the girls' locker room.  <br>\
	Trying to buy clothes in the girls' department.  <br>\
	Trying to put on makeup or earrings.   Would he have to wear them or could he basically be a tomboy and pretty much be <a href='switchlookingaround'>his old self?</a></p>"
);

undum.game.situations['switchlookingaround'] = new undum.SimpleSituation(	
	"<p>And then, he looked around his room for the first time.  Yes, the Lakers sheets were still the same, but everything else had changed.  Where once towered the icons of sports in heroic and seemingly impossible poses of leaps, jumps, and spins, were <a href='./ryka' class='once' onClick='_gaq.push([\"_trackEvent\",  \"Switcheroo\", \"SwitchPoem\", \"ReadSwitchPoem\"]);'>poems, yes, poems</a> and ponies and unicorns and -- ugh, boy bands!  And worst of all, his sky blue walls were, yes, bright popped-bubble <a href='switchgumppink'>bubble gum pink.</a></p>",        
{
       	actions:{
            'ryka' : function(character, system, action){
			  system.setCharacterText(
		     // "<p>Hello?</p>"
			  "<h1>Poetry Power-up</h1><p>'When other people say believe' <br/>by Ryka Aoki<br/>Excellent find!</p>"
				);
				 
		   system.write("<center><h3>Poetry Power-up</h3></center>\
				<center>When other people say believe By Ryka Aoki</center><p>When other people say believe,<br/>\
				they think of wishes on a star,<br/>\
				of mermaids or of unicorns.<br/>\
				But what of being who you are?</p>\
				<p>So silly, isn't it, to think<br/>\
				that magic happens far away--<br/>\
				when all the magic that one needs<br/>\
				is just to hear somebody say,</p>\
				<p>'When I believe, I believe in you<br/>\
				and not what others say is true.<br/>\
				The girl you are, the girl you'll be<br/>\
				shall always be a friend to me.'</p>\
				<hr/>\
				<p class='transient'><strong>Poetry Power-up:</strong></p>\
				<p class='transient'>Look for these hidden in the story to gain special powers to use \
				when facing challenges.</p>");
            system.setQuality("poetry", character.qualities.poetry+7);
		   }
           }
         }
	);

	
undum.game.situations['switchgumppink'] = new undum.SimpleSituation(	
	"<p><a href='switchnightstandearrings'>Yoopers!</a></p>"
);


// This is the branch that comes from Waiting in the Bathroom

undum.game.situations['switchregainbreath2'] = new undum.SimpleSituation(		
	"<p>It was only once he had regained his breath that he began to fully consider the implications of his situation. A girl.  Being a girl.  This was so weird.  And although he had once watched a TV show about a boy who could become a girl and then change back again, he was fairly certain that this was unusual -- if not impossible -- without some sort of major surgery.  But how?  What could <a href='switchmindfilled2'>possibly have happened?</a></p>"
);

undum.game.situations['switchmindfilled2'] = new undum.SimpleSituation(	
	"<p>His mind filled with strange scenes:<br>\
	Trying to get dressed as a girl in the boys' locker room.  <br>\
	Trying to get dressed as a girl in the girls' locker room.  <br>\
	Trying to buy clothes in the girls' department.  <br>\
	Trying to put on makeup or earrings.   Would he have to wear them or could he basically be a tomboy and pretty much be <a href='switchlookingaround2'>his old self?</a></p>"
);

undum.game.situations['switchlookingaround2'] = new undum.SimpleSituation(	
	"<p>And then, he looked around his room for the first time.  Yes, the Lakers sheets were still the same, but everything else had changed.  Where once towered the icons of sports in heroic and seemingly impossible poses of leaps, jumps, and spins, were <a href='./ryka' class='once' onClick='_gaq.push([\"_trackEvent\",  \"Switcheroo\", \"SwitchPoem\", \"ReadSwitchPoem\"]);'>poems, yes, poems</a> and ponies and unicorns and -- ugh, boy bands!  And worst of all, his sky blue walls were, yes, bright popped-bubble <a href='switchgumppink2' class='once'>bubble gum pink.</a></p>",        
{
       	actions:{
            'ryka' : function(character, system, action){
			  system.setCharacterText(
		     // "<p>Hello?</p>"
			  "<h1>Poetry Power-up</h1><p>'When other people say believe'<br/> by Ryka Aoki<br/>Great find!</p>"
				);
				 
		   system.write("<center><h3>Poetry Power-up</h3></center>\
				<center>When other people say believe By Ryka Aoki</center><p>When other people say believe,<br/>\
				they think of wishes on a star,<br/>\
				of mermaids or of unicorns.<br/>\
				But what of being who you are?</p>\
				<p>So silly, isn't it, to think<br/>\
				that magic happens far away--<br/>\
				when all the magic that one needs<br/>\
				is just to hear somebody say,</p>\
				<p>'When I believe, I believe in you<br/>\
				and not what others say is true.<br/>\
				The girl you are, the girl you'll be<br/>\
				shall always be a friend to me.'</p>\
				<hr/>\
				<p class='transient'><strong>Poetry Power-up:</strong></p>\
				<p class='transient'>Look for these hidden in the story to gain special powers to use \
				when facing challenges.</p>");
            system.setQuality("poetry", character.qualities.poetry+7);
		   }
           }
         }
	);

	
	
undum.game.situations['switchgumppink2'] = new undum.SimpleSituation(	
	"<p><a href='switchclothespick'>Yoopers!</a></p>"
);

undum.game.situations['switchclothespick'] = new undum.SimpleSituation(
	"<p>Well, he couldn't stand there in those girly pajamas all day.  Standing? Was he really standing on his own? Without anyone to stand at his side looking irritated or sighing in his ear. What a feeling!</p>\
	<p>That feeling made the next shock much less shocking.  His closet was filled with bright, glittery, frilly girl clothes in array of the legendary girl colors from bright pink to violet to teal and aquamarine.  <a href='switchclothespick2'>Dayglow. Neon. Ugh.</a></p>"
);

// add polka dots

undum.game.situations['switchclothespick2'] = new undum.SimpleSituation(
		"<p>So what to wear?</p>",
			{
		enter: function(character, system, from) {
			var pants = new Array ();
			var tops = new Array ();
			var shoes = new Array ();
			var hair = new Array ();
			// switch to cropped pants? 
			pants = ["pink Capris", "black jeggings", "ripped jeans" ];
			mypants = pants;
			tops = ["bright pink tee", "shimmery purple shirt", "grey t-shirt" ];
			// change color on the bow clip -- make it a sparkle clip?
			hair = ["pig tails", "sparkly bow clip", "uncombed hair"];
			// switch to canvas sneakers?
            shoes = ["pink tennis shoes",  "purple flats", "canvas hightops"];
		    var numboys = new Array();
            var numpants = new Array (); 
			var numtops =  new Array ();
			var numshoes = new Array ();
			var numhair = new Array ();
			numboys = [0, 1, 2];
			numboys2 = [0, 1, 2];
			numboys3 = [0, 1, 2];
			numboys4 = [0, 1, 2];
			numpants = numboys.shuffle();
			numtops =  numboys2.shuffle();
			numshoes =  numboys3.shuffle();
			numhair =  numboys4.shuffle();
			var choicepants=pants[0];
			var choicetops = tops[1];
			var choicehair= hair[2];
			var choiceshoes = shoes[0];
			clothespick = function(choicenumber) {
				var y=numpants[choicenumber];
				//eval("var thischoice = 'choice'+kind");
				choicepants= pants[y];
				var j = pants.indexOf(choicepants);
				$("#choicepants").html("<p>" + choicepants + "</p>");
				return;
				}
		     // Make Clothespick accept 2 arguments, number and item
			 // so clothespick(value,'tops')
			 // clothespick = function (choicenumber, kind)
			 // then eval adds tops to everything
			 topspick = function(choicenumbertops) {
				var y=numtops[choicenumbertops];
				choicetops= tops[y];
				var t = tops.indexOf(choicetops);
				$("#choicetops").html("<p>" + choicetops + "</p>");
				return;
				}
			 
			 
			shoespick = function(choicenumbershoes) {
				var z=numshoes[choicenumbershoes];
				choiceshoes= shoes[z];
				var k = shoes.indexOf(choiceshoes);
				$("#choiceshoes").html("<p>" + choiceshoes + "</p>");
				return;
				}
				
			hairpick = function(choicenumberhair) {
				var y=numhair[choicenumberhair];
				choicehair= hair[y];
				var t = hair.indexOf(choicehair);
				$("#choicehair").html("<p>" + choicehair + "</p>");
				return;
				}
	      
			setoutfit = function() {
			      character.sandbox.pickoutfit=true;
				  $('#pants0, #pants1, #pants2').attr("disabled", true);
				  $('#tops0, #tops1, #tops2').attr("disabled", true);
				  $('#hair0, #hair1, #hair2').attr("disabled", true);
			      $('#shoes0, #shoes1, #shoes2').attr("disabled", true);
				  $('#selectoutfit').attr("disabled", true);
				  var pantsfinal = pants.indexOf(choicepants);
				  var topsfinal = tops.indexOf(choicetops);
				  var hairfinal = hair.indexOf(choicehair);
				  var shoesfinal = shoes.indexOf(choiceshoes);
				  //var matchingtest = (pantsfinal+topsfinal+hairfinal+shoesfinal) % 4;
				  var variation = Math.abs((pantsfinal * 4) - (pantsfinal+topsfinal+hairfinal+shoesfinal));
				  character.sandbox.outfitmismatch = variation;
				  //store this number: Not getting the most accurate results here, tho -- getting too thrown by one item
				  //Try adding up all the clothing items from the pants choice, subtract the sum of the real choices, take absolute of that.
				  if (variation==0) {
				  system.write("<p>Looking in the mirror, Derik saw his old self wearing girl clothes, but at least the outfit matched!</p>");
				  character.sandbox.outfitmatch=true;
				  character.sandbox.outfit = pantsfinal;
				  switch (character.sandbox.outfit)
					{
					case 0:
					system.write("<p>But, it was time <a href='switchbreakpink'>to go downstairs as...</a></p>");
					break;
					case 1:
					system.write("<p>But, it was time <a href='switchbreakshimmer'>to go downstairs as...</a></p>");
					break;
                    case 2:
		  		    system.write("<p>But, it was time <a href='switchbreaktomboy'>to go downstairs as...</a></p>");
					break;
					default:
           			system.write("<p>But, it was time <a href='switchbreakmismatch'>to go downstairs as...</a></p>");
					break;
			      }
				  }
				  else {
				  // Save a number representing how mismatched the outfit is. perhaps the distance from 4 times the pants number
				  system.write("<p>Looking in the mirror, Derik saw his old self wearing girl clothes, and the mismatched outfit didn't help.</p>");
				  system.write("<p>But, it was time <a href='switchbreakmismatch'>to go downstairs as...</a></p>");
				  }
	
				  // Will need to refresh the screen after this game
				return;
			}
			system.write("<p>Derik needed to choose an outfit.  Here's what was in her closet.  Press the buttons of the outfit you want her to wear, and when you're done, press CHOOSE OUTFIT.</p><center><table id='message' width=400px><tr><td width='25%'><button type='button' id='pants0' style='height:4em; width:8em' value=0 onclick='clothespick(value)'>" + pants[numpants[0]] + "</button></td><td width='25%'><button type='button' id='pants1' style='height:4em; width:8em'  value=1 onclick='clothespick(value)'>" +pants[numpants[1]]  + "</td><td width='25%'><button type='button' id='pants2' style='height:4em; width:8em'  value=2 onclick='clothespick(value)'>" + pants[numpants[2]]+ "</td><td width='25%'><span id='choicepants'>" + choicepants + "</span></td></tr>\
			<tr><td><button type='button' id='tops0' value=0  style='height:4em; width:8em' onclick='topspick(value)'>" + tops[numtops[0]] + "</button></td><td><button type='button' id='tops1' value=1  style='height:4em; width:8em' onclick='topspick(value)'>" +tops[numtops[1]]  + "</td><td><button type='button' id='tops2' value=2  style='height:4em; width:8em' onclick='topspick(value)'>" + tops[numtops[2]]+ "</td><td><span id='choicetops'>" + choicetops + "</span></td></tr>\
			<tr><td><button type='button' id='hair0' value=0  style='height:4em; width:8em' onclick='hairpick(value)'>" + hair[numhair[0]] + "</button></td><td><button type='button' id='hair1' value=1  style='height:4em; width:8em'  style='height:4em; width:8em' onclick='hairpick(value)'>" +hair[numhair[1]]  + "</td><td><button type='button' id='hair2' value=2  style='height:4em; width:8em' onclick='hairpick(value)'>" + hair[numhair[2]]+ "</td><td><span id='choicehair'>" + choicehair + "</span></td></tr>\
			<tr><td><button type='button' id='shoes0' value=0  style='height:4em; width:8em' onclick='shoespick(value)'>" + shoes[numshoes[0]] + "</button></td><td><button type='button' id='shoes1' value=1  style='height:4em; width:8em' onclick='shoespick(value)'>" +shoes[numshoes[1]]  + "</td><td><button type='button' id='shoes2' value=2  style='height:4em; width:8em' onclick='shoespick(value)'>" + shoes[numshoes[2]]+ "</td><td><span id='choiceshoes'>" + choiceshoes + "</span></td></tr>\
			</table></center>\
			Once you've lined up the look you like, press <button type='button' id='selectoutfit' onclick='setoutfit(choicepants, choicetops, choicehair, choiceshoes)'>choose outfit</button>"); 
			// add a button, the button's value is the value of pants[pop]
			
//If it's the worst outfit possible, they stop and stare at you
//some obnoxious kid makes a joke -- Juan: even I coulda done better than that
//Ichel: well, you're always praticing on my dolls, so you should know.
//If you where the all pink outfit, you get reactions
//If you where the Tom Boy, you get reactions
//If you wear the sparkly, you get reactions...
//array  tops [grey t-shirt, bright pink tee, Shimmery purple shirt]
//array  bottoms [ripped jeans, Pink pedal pushers, black jeggings]
//array  hair [uncombed hair, pig tails, Hair with pink bow clip]
//array  shoes [white sneakers, pink tennis shoes, purple flats]
// replace pedal pushers with cropped pants? Capris?
//for each array 
// make an array with random numbers
// shuffle it.
//display the item 
// display the item in the array

// make each of the these a button.
//pressing the button assigns the value of that array to a button
// then it compares it to the other ones.        

// Add choose button that locks in outfit
// either 1 point for everything that matches pants
// or matches = true if all the items match
// otherwise matches = fals
// if the array[x]=array[x] no points.
// otherwise array[x]-array[y]
// multiply by 10 the subtract?


// if the array[x]=array[x] no points.
// otherwise array[x]-array[y]
// multiply by 10 the subtract?
		},
		exit: function(character, system, from) {
		 $('#selectoutfit').attr("disabled", true);
		 $('#pants0, #pants1, #pants2').attr("disabled", true);
		 $('#tops0, #tops1, #tops2').attr("disabled", true);
		 $('#hair0, #hair1, #hair2').attr("disabled", true);
		 $('#shoes0, #shoes1, #shoes2').attr("disabled", true);		   
		}
		
	}
        
   );
   
 undum.game.situations['switchbreakpink'] = new undum.SimpleSituation(
		"<p>... <a href='switchbreakintro'>the girl in pink.</a></p>",
 	{
		enter: function(character, system, from) {
					character.sandbox.outfit = 0;
									 if (character.qualities.gender<4){
          			system.setQuality("gender", character.qualities.gender +2);
					}
				}
	}
 );
 
 undum.game.situations['switchbreakshimmer'] = new undum.SimpleSituation(
 "<p>...<a href='switchbreakintro'>the purple shimmery girl.</a></p>",
 	{
		enter: function(character, system, from) {
		character.sandbox.outfit = 1;
        system.setQuality("gender", character.qualities.gender +1);
 }
 }
 );
 
 undum.game.situations['switchbreaktomboy'] = new undum.SimpleSituation(
			"<p>...<a href='switchbreakintro'>the new tomboy</a></p>",
 	{
		enter: function(character, system, from) {
					character.sandbox.outfit = 2;
									 if (character.qualities.gender>-5) {
 				    system.setQuality("gender", character.qualities.gender -2);
					}
	}
	}
 );
 
 undum.game.situations['switchbreakmismatch'] = new undum.SimpleSituation(
 "<p>...<a href='switchbreakintro'>a mismatched mess.</a><em> Now who's to say what matches and what doesn't? Well, me I guess.</em></p>",
 	{
		enter: function(character, system, from) {
						character.sandbox.outfit = 3;
										 if (character.qualities.gender>-6){
            			system.setQuality("gender", character.qualities.gender -1);
						}
				}
		}
 );


// Earring backs:
// Fuze Beads
// Erasers
// Put the fuze beads on the earrings?

undum.game.situations['switchnightstandearrings'] = new undum.SimpleSituation(
	"<p>And then, he noticed that on his nightstand, where his retainer once sat, were these little earrings, some tiny rubber things, and some pencils.  He picked them up and began to examine them: the earrings were butterflies, the pencils were pencils, and the rubber things, well, looked like tiny little Fuse Beads or rubber pasta, tiny little tubes.  Why were the tiny rubber pieces here? What did they have to do with earrings? Or were they a <a href='switchearchoice'>new fashion accessory?</a>"
);

undum.game.situations['switchearchoice'] = new undum.SimpleSituation(
	"<p>The tiny holes in his earlobes told him his ears were in fact pierced.  But when he placed the little earrings in his ears, they felt like they would fall out with the slightest head movement.  What could he do?</p>\
	<ul class='options'>\
	<li><a href='switchfuseears'>Put the Fuse-Bead looking things in his ears?</a></li>\
	<li><a href='switchearringsfirst'>Put the earrings in and then do something with the little Fuse-Bead looking things?</a></li>\
	<li><a href='switchfusefuse'>Put in the earrings and try to fuse the Fuse Beads with, say, super-power heat vision?</a></li>\
	<li><a href='switchfusepencils'>Forget the Fuse Beads! Use the pencils to help with the earrings?</a></li></ul></p>"
);

undum.game.situations['switchfuseears'] = new undum.SimpleSituation(
"<p>Derik lifted the Fuse Beads and tried cramming one in each ear hole.  Something didn't look quite right.  Then he tried shoving in the earrings, but they couldn't fit with the Fuse Beads in.  Oh, my. Being a girl was going to be <a href='switchbreakfastcall'>harder than he thought.</a></p>",
	{
	 enter: function(character, system, from) {
	 				 if (character.qualities.gender>-6){
			     system.setQuality("gender", character.qualities.gender -1);
				 }
            } 
	}
 );

undum.game.situations['switchearringsfirst'] = new undum.SimpleSituation(
	"<p>Somehow, she knew just how to put in the earrings and that the little rubber pieces were the slide-on backs to keep the earrings from sliding out.  At least she knew that much about <a href='switchbreakfastcall'>how to dress.</a></p>",
	{
	 enter: function(character, system, from) {
	 				 if (character.qualities.gender<5){
			     system.setQuality("gender", character.qualities.gender +1);
				 }
            } 
	}
 );

undum.game.situations['switchfusefuse'] = new undum.SimpleSituation(
	"<p>Training his eyes on the Fuse Beads, he concentrated with all his might and -- nothing! He squeezed them together trying to use his super strength and -- nope.  It was really too bad changing into a girl hadn't changed his hands into irons because then he could make cool designs with the Fuse Beads.  Plus, he could've made grilled cheese sandwiches with his hands.  But how could he pick his nose?  Oh, no, <a href='switchbreakfastcall'>we're off topic.</a></p>",
	{
	 enter: function(character, system, from) {
	 				 if (character.qualities.gender>-6){
			     system.setQuality("gender", character.qualities.gender -1);
				 }
            } 
	}
 );

undum.game.situations['switchfusepencils'] = new undum.SimpleSituation(
"<p>This is some super-secret girl knowledge here! In a pinch, or so I'm told, since I don't have ears, you can always break off a piece of an eraser and use it as an earring back. It's easiest with stud earrings. Call it <a href='switchbreakfastcall'> a jewelry hack!</a></p>",
	{
	 enter: function(character, system, from) {
	 				 if (character.qualities.gender<5){
			     system.setQuality("gender", character.qualities.gender +1);
				 }
            } 
	}
 );


undum.game.situations['switchbreakfastcall'] = new undum.SimpleSituation(
	"<p>Just then, Derik heard the conch shell: Mrs. Wobbles was calling them all to breakfast.  His heart stopped.  What next?</p>\
<ul class='options'>\
	<li><a href='switchbreakfastgo'>Go down to breakfast?</a></li>\
	<li><a href='switchbreakfaststay'>Stay up in his room the rest of his life?</a></li>\
	</ul>"
);

//switchclothespick

undum.game.situations['switchbreakfaststay'] = new undum.SimpleSituation(
	"<p>Derik stayed in the room for the rest of his days.  Each day, he watched in the mirror as his body changed from a girl's to a woman's and then an old woman's.  Well, this was fun, he said, as he collapsed into his bed as an old woman and turned on another episode of 'Golden Girls' or 'Matlock.' Well that's the way life goes.  (Ask your grandparents about these shows and why they drink so <a href='switchbreakfaststay2'>much prune juice.)</a></p>"  
);

undum.game.situations['switchbreakfaststay2'] = new undum.SimpleSituation(
	"<p>But he couldn't sit there forever. Eventually, his belly roaring in a most unladylike way [or in a way unbecoming a polite young girl], he was anxious to walk down around the house on his own for the first time <a href='switchclothespick'>in ten years.</a></p>"  
// How did he lose the ability to walk?
// he headed down the hall toward the dining room, walking by himself, amazingly, for the first time
);

undum.game.situations['switchbreakfastgo'] = new undum.SimpleSituation(
	"<p>Derik stayed up in his room as long as he could, largely trying to find a suitable outfit.  Several times, his earrings hooked on a shirt or he just collapsed <a href='switchclothespick'>in a heap.</a></p>"
);

undum.game.situations['switchbreakintro'] = new undum.SimpleSituation(
			"<p>As he arrived downstairs at the table, he expected looks of shock and horror, but instead nobody blinked. Well, Mildred did make a comment about his outfit:</p>",
			{
		enter: function(character, system, from) {
		if (character.sandbox.outfitmatch==true){
			switch (character.sandbox.outfit)
					{
					case 0:
         system.write("<p>'Wow, I never new clothes could be so...pink.'</p>");
					break;
					case 1:
		system.write("<p>'Wow, you are so...sparkly.'</p>");
					break;
                    case 2:
		system.write("<p>'Wow, that look is awesome. My mother always wear an outfit that you wouldn't mind wearing while gutting a fish.'</p>");
					break;
					default:
		system.write("<p>'Wow.'</p>");
					break;
			      }
		}
		 else {
		 system.write("<p>'Hmm, that outfit. Um. Just kinda grabbed whatever, huh? Don't worry. I do that sometimes.'</p>");
		 }
	     system.write("<p>Then, Mrs. Wobbles said, 'Children, I'd love for you all to meet a new guest here at the house. Meet Denise.'</p>\
	<p>'Denise?' said Derik, <a href='switchbreakintro2'>shocked again.</a></p>");
				},
		}
        
   );

undum.game.situations['switchbreakintro2'] = new undum.SimpleSituation(
	"<p>'Yes, Denise,' replied Mrs. Wobbles, ushering him over to the table. 'She just arrived last night, quite late, too late for any of you to meet her.  So make her feel at home as you always do.'</p>\
	<p>'I didn't hear anyone coming in last night,' whispered Leroy to his brother Stevie between shovels of eggs and hashbrowns, but Mrs. Wobbles shot him one of her 'Don't you dare' looks, and Leroy thought he saw his pancake turn into a frowny face.  He covered it in syrup till he <a href='switchbreakintro3'>couldn't see it anymore.</a></p>" 
);

undum.game.situations['switchbreakintro3'] = new undum.SimpleSituation(
	"<p>The children welcomed Denise warmly, as was the way at the Tangerine House, and within a few minutes they returned to eating and the usual morning buzzing.  Derik, or Denise, tried to regain Mrs. Wobbles' attention, but she was consumed in a towering stack of mail.  A pillar of letters, each one making her frown in a different way.  Derik had seen his grandmother make similar faces at piles of bills.   She soon rose from the table and grabbed the receiver from the old-time phone hanging on the wall, <a href='switchbreakintro4'>cranking its metal handle.</a></p>"
);


undum.game.situations['switchbreakintro4'] = new undum.SimpleSituation(
	"<p>Derik tried to listen to the conversation, but could only get bits and pieces over the din of breakfast.  Something about the house.  Something about HIM being back again. That he was just an agent for Santana. (Could she mean Carlos Santana?)  All the while, she waved a paper, maybe a bill, in the air as though the person on the other line could see it.</p>\
	<p>Now it was time to find somewhere to sit.  Should he sit over by the boys, in his usual spot, next to Mildred since that's what a girl would do, or by himself?</p>\
	<ul class='options'>\
	<li><a href='switchbreakboys'>Sit over with the boys because you're still a boy a heart.</a></li>\
	<li><a href='switchbreakmildred'>Sit next to Mildred and hope she doesn't recognize you.</a></li>\
	<li><a href='switchbreakalone'>Sit over by yourself and try to make yourself invisible.</a></li>\
	</ul>"
);

undum.game.situations['switchbreakboys'] = new undum.SimpleSituation(
		"",
			{
		enter: function(character, system, from) {
		system.write("<p>Derik filled a plate of food and walked over to his usual spot with the boys.</p>\  <p>'Hello,' said Juan making some room.</p>");
		if (character.sandbox.outfitmatch==true){
			switch (character.sandbox.outfit)
					{
					case 0:
         system.write("<p>Stevie said, 'Love the pink thing you've got going on.'</p>");
					break;
					case 1:
		system.write("<p>Stevie said, 'You are glittering like the stars in Lucky Charms.'</p>");
					break;
                    case 2:
		system.write("<p>Stevie said, 'Hey, you like the kinda girl who can hang with the boys.'</p>");
					break; 
					default:
		system.write("<p>Stevie said, 'Hel-lo.'</p>");
					break;
			      }
		}
		 else {
		 system.write("<p>Stevie said, 'Looks like you got a style all your own there, girl. You are on fleek!'</p>");
		 }
		 system.write("'<p>Leroy stared at his brother and just said, 'Ewwwwwwww.'</p>\
		 <p>'Stevie,' Juan said, elbowing him hard, 'Stop flirting with the girl. Give her some space to breathe. Right, chica?'</p>\
		 <p>'Ah, man,' said Stevie, 'You don't know anything about girls.'</p>\
		 <p>'Why not?' replied Juan. 'I've been playing with <em>you</em> for months.</p>\
		 <p>Stevie stomped on Juan's foot hard causing Juan to yelp with pain.  Mrs. Wobbles gave one glance, and the boys were silent.</p>\
		 <p>All Derik could do is look down at his plate as he felt the color rushing to his <a href='switchbreakintro6'>cheeks like lava.</a></p>");
		 }
	}
);

undum.game.situations['switchbreakalone'] = new undum.SimpleSituation(
	"<p>Derik filled a plate full of food and grabbed a seat off to the side and listened to the voices all around him. Friends joking.  Whispers and giggles. The laughter of Stevie and Leroy as Juan cracked a joke, probably about him.</p>\
	<p>That's one of the things about sitting off to the side.  It turns every back away from you and turns every joke and laugh against you.  That's how Derik felt at least.  And the worst part is that once you've chosen the seat on the side, there seems to be no way back into the center.</p>\
	<p>But at least now Derik could focus on trying to eat like a girl, <a href='switchbreakintro6'>whatever that meant.</a></p>"
);

undum.game.situations['switchbreakmildred'] = new undum.SimpleSituation(
	"<p>Derik filled a plate with pancakes and sat down next to Mildred, trying to keep her hair in front of her face so Mildred wouldn't look too closely.</p>\
	<p>'She's a little bit eccentric,' whispered Mildred from beside Derik, 'But she loves us all more than you'll ever know.'</p>\
	<p><em>'More than you'll ever know,'</em> Derik could remember Mrs. Wobbles whispering to him one night after <a href='switchbreakintro5'>one of his many nightmares.</a></p>"
);

undum.game.situations['switchbreakintro5'] = new undum.SimpleSituation(
	"<p>Apparently, Mildred hadn't recognized Derik in his new form, and finally it began to settle in to his head that perhaps  no one could recognize him in that new form.  But wouldn't people wonder what had happened to Derik? And what was this girl doing sleeping in his room?  There were more questions than answers, but his hunger soon distracted him, and several large sausages later, he sat back in his chair full.  Mildred looked horrified.</p>\
	<p>'Hungry much?'</a></p>\
	<p>Derik belched his reply and <a href='switchbreakintro6'>Mildred frowned.</a></p>"
);

undum.game.situations['switchbreakintro6'] = new undum.SimpleSituation(
	"<p>A surprise ring of the doorbell took Mrs. Wobbles off the phone from what seemed to be a very upsetting conversation to the front of the house, where some unexpected guests had just appeared.</p>\
	<p>'Almosts!! Almosts!!' cried the kids, for this is what they called the potential mothers and fathers who would stop by Mrs. Wobbles' house when they were considering adopting.  Because you could never tell whether they would actually connect and commit, they were always 'Almosts.' Almost adopters. Almost new mommies and daddies. Almost worth <a href='switchbreakalmosts1'>getting excited about.</a></p>"
);

undum.game.situations['switchbreakalmosts1'] = new undum.SimpleSituation(
	"<p>'Now children, settle down,' said Mrs. Wobbles. 'Don't scare them away by acting like a bunch of stampeding cows.  Play it cool.'  'Play it cool' was Mrs. Wobbles' approach to everything, but the kids were kids, and even Mildred had already begun combing her hair excitedly.<p>\
	<p>With a wssh and a whirl, Mrs. Wobbles was down the hall, coming back only a few moments later with some news.</p>\
	<p>'The family at the door are a lovely couple that had contacted me several weeks ago.   It seems they've been looking at the files of the children here to find a good match for them <a href='switchbreakalmosts2'>and their circumstance.</a></p>"
);

 undum.game.situations['switchbreakalmosts2'] = new undum.SimpleSituation(
	"<p>'They followed one child from her last placement, and now that she is with us, they'd like to spend the afternoon with...<p>\
	<p>The room was silent as <a href='switchbreakalmosts2a'>a librarian's dream.</a></p>"
	);
	
undum.game.situations['switchbreakalmosts2a'] = new undum.SimpleSituation(	
	"<p><a href='switchbreakalmosts3'>'Denise.'</a></p>"
);

undum.game.situations['switchbreakalmosts3'] = new undum.SimpleSituation(
	"<p>The reaction was not all at once. 'Denise? Did she say Denise? Is that the new girl? Just our luck, the new girl.' But soon it was boiling and bubbling like the great oatmeal pot that sat on the stove throughout every breakfast. Mrs. Wobbles silenced them all with a snap.<p>\
	<p>'Denise is the one that might complete their family, so Denise it is. We are very happy for her.'<p>\
	<p>There was another moment of quiet when you could hear the refrigerator coughing a little. But it was soon followed by <a href='switchbreakalmosts4'>cheers for Denise.</a></p>"
);

undum.game.situations['switchbreakalmosts4'] = new undum.SimpleSituation(
/*
if choicehair==hair[numhair[2]], say "Good, bet you'll need a skirt. They want a daughter afterall"
else: 
They want a daughter -- skirts, pigtails, you know!
*/
	"<p>They circled her with congratulatory hugs and pats, cheered her preparations, and gave her endless advice.</p>\
	<p>'You are NOT wearing THAT outfit,' said Mildred and had her change into a skirt. 'They want a daughter -- skirts and flowers, yes, but not too much, you know?'</p>\
	<p>And when Denise reappeared, now properly girlish, the children marched her to the door.<p>\
	<p>It was only once she was gone that Stevie came across the empty wheel chair and said, 'Hey,  where's Derik?' But a magical bat appeared, glowing bright and green, and following it into the back yard, Stevie forgot all about his question.  Mrs. Wobbles smiled and turned to peer out the window at Denise getting into a car <a href='switchstation'>with the Sheepheads.</a></p>"
);

undum.game.situations['switchstation'] = new undum.SimpleSituation(
"<p>The car was an ordinary station wagon.  Nothing special about the inside, no leather seats, no DVD players, smelled about the way you'd expect a middle-aged couple's car would -- except one magical thing, Derik, or Denise, rather (I've got to get used to that!) entered it all on her own.  No one had to lift her up, place her in, get her settled, fuss or fret.  Denise had yanked open the door, hopped in, and buckled up and was now smiling from ear to ear so much so that the Mr. and Mrs. Joe and Edna Sheephead must've thought her <a href='switchstation1'>to be outright mad.</a></p>"
);

undum.game.situations['switchstation1'] = new undum.SimpleSituation(
	"<p>'Everything all right back there?' asked Edna in the way that nervous adults ask questions that are basically confirming the obvious.</p>\
	<p>'Oh, yes, um, Mrs. Sheep -- er' here Denise stammered a bit.</p>\
	<p>'Sheephead,' said Joe, 'Like the <a href='./sheephead'>California Sheephead</a>, the fish?'</p>\
	<p>'But,' Edna swooped in like a California Condor, 'you can call us Edna and Joe,' and then after a slight pause that barely hid her joy, 'for now.'</p>\
	<p>'Okay, Edna,' said Denise, but it sounded strange to everybody in the car, especially Denis to whom adults had always at least been Ms. or Mr. followed by <a href='switchstation2'>their first name.</a></p>",
 {
       	actions:{
            'sheephead' : function(character, system, action){
            system.write("<p class='transient'>Ah, I'm glad you were curious.  The California Sheephead is a salt water fish, found off the coast of California.  It has the unusual property of all the fish being born female and then, given certain circumstances, like when she gets sick of all the long lines at bathrooms, changing into a male.</p>");
			system.animateQuality(
				'page', character.qualities.page + 1
				);
            	}
           }
         }
	);



undum.game.situations['switchstation2'] = new undum.SimpleSituation(
	"<p>'So, where would you like to go? We were thinking the movies or the skating rink or a picnic?'</p>\
	<p>'Joe,' scolded Edna with a look stern but loving, 'Let her answer. Let her get her breath.  She's just getting settled.'</p>\
	<p>'Oh, sorry,' said Joe, who looked in the rear view mirror a little bit like a wounded puppy.</p>\
	<p>'Oh, no, that's quite all right,' said Denise, trying to keep her mouth from smiling -- which was just impossible. 'I'm excited, too.'</p>\
	<p>And the two adults exchanged relieved glances, like when they find out the blood in your mouth is just from a baby tooth that just popped out.</p>\
		<ul class='options'>\
			<li><a href='switchmovies' onClick='_gaq.push([\"_trackEvent\",  \"Switcheroo\", \"SwitchOuting\", \"Movies\"]);'>The Movies</a></li>\
			<li><a href='switchskate' onClick='_gaq.push([\"_trackEvent\",  \"Switcheroo\", \"SwitchOuting\", \"Skating\"]);'>Ice Skating</a></li>\
			<li><a href='switchpicnic' onClick='_gaq.push([\"_trackEvent\",  \"Switcheroo\", \"SwitchOuting\", \"Skating\"]);'>A Picnic</a></li>\
		</ul>"
);

undum.game.situations['switchmovies'] = new undum.SimpleSituation(
	"<h1>The Movies</h1><p>'To be honest, I'd love to go to the movies,' Denise said, and she burped. </p>\
	<p>'Excuse me,' she flushed.</p>\
	<p>Where did that come from?  That was a meaty burp! Not a dainty little burp, but a meaty-tasting, breakfast-sausage-again, kind of burp. The kind that comes with a mouthful of taste.  But girls don't do that? Or do they?</p>\
	<p>'She sounds like you,' said Joe to Edna.</p>\
	<p>'She's a lucky girl,' said Edna, swatting <a href='switchmovies2'>Joe for emphasis.</a></p>"
);

undum.game.situations['switchmovies2'] = new undum.SimpleSituation(
	"<p>They drove off to the movies.  The choices were an action film called <em>Super Ninja Alien Vampire Dinosaurs in Space</em> or a movie about a girl who becomes a global rockstar by posting a video of herself singing on the Internet.</p>\
		<ul class='options'>\
			<li><a href='switchsuperninja'>Super Ninja Alien Vampire Dinosaurs in Space</a></li>\
			<li><a href='switchtotally'>Totally Texting Tween Idol</a></li>\
		</ul>"
);

undum.game.situations['switchsuperninja'] = new undum.SimpleSituation(
	"<h1>Super Ninja Alien Vampire Dinosaurs in Space</h1>\
	<p>Super. Ninja. Alien. Vampire. Dinosaurs. in. Space.</p>\
	<p>Say no more.</p>\
	<p>The awesomeness of this movie is obvious to any boy.</p>\
	<p>Except Derik was not really a boy any more.</p>\
	<p>And the movie was terrible.</p>\
	<p>It was basically an hour long commercial for the toy versions of the Super Ninja Alien Vampire <a href='switchsuperninja2'>Dinosaurs of the title.</a></p>",
	{
	 enter: function(character, system, from) {
	 				 if (character.qualities.gender>-6){
			     system.setQuality("gender", character.qualities.gender -1);
				 }
            } 
	}
 );

undum.game.situations['switchsuperninja2'] = new undum.SimpleSituation(
	"<p>After the movie, Denise went to the little girls room with Edna, covering her eyes as she went to the stall. When Denise came out, Edna jumped out at her with a 'ROAR,' pretending to be a Super Ninja -- <em>could I just say, SNAVDS? That would make my life so much easier! --</em>  But she wasn't like a SNAVDS at all. She was just a frightening bag of potential momness.  And Denise was actually so scared she screamed like, well, like a girl.</p>\
	<p><a href='switchsuperninja3'>'Are you okay?'</a></p>"
);

undum.game.situations['switchsuperninja3'] = new undum.SimpleSituation(
	"<p>'Yes,' Denise said.  Good thing she went pee before the scare.</p>\
	<p>Edna smiled. 'Sorry, I do that to Joe all the time.  He hates it.  But I just can't help myself.'</p>\
	<p>Denise was starting to like Edna.  She noticed that Edna didn't wear makeup.  That was interesting.  Could you be a woman and not wear makeup?  As Derik, he had never known any woman who hadn't. </p>\
	<p>When they came out they saw Joe, sneaking a peek at the <a href='switchrejoin'>tween adventure texting movie.</a></p>"
);

undum.game.situations['switchtotally'] = new undum.SimpleSituation(
	"<h1>Totally Texting Tween Idol</h1>\
	<p>I cannot describe this movie.   I just can't.  Some movies are better off left to your imagination.  Or better yet, since they were not created with much imagination, better left to the confines of a DVD box or movie poster.</p>\
	<p>It should be enough to say that the movie contained equal portions pink costumes, glitter, giggling, singing, shopping, sighing, and hairstyling, not to mention a few zany mixups involving a glass a pink lemonade spiked <a href='switchrejoin'>with Pop Rocks.</a></p>",
	{
	 enter: function(character, system, from) {
				 if (character.qualities.gender<5){
			     system.setQuality("gender", character.qualities.gender +1);
				 }
				 system.write("<p class='transient'>This movie should've come with free lip gloss. Nice pick.</p>");
            } 
	}
 );


undum.game.situations['switchpicnic'] = new undum.SimpleSituation(
	"<h1>A Picnic</h1><p>Joe and Edna exchanged broad smiles.  Clearly this was a good choice.  They had a little argument - I don't even know if I could call it that -- a little disagreement -- a back and forth -- nothing like the kinds of arguments Denise had seen before as Derik -- like when foster parents argued about how they would manage his wheel chair in their lives -- going on vacation or going to the beach -- if those were rain storms this was just a sprinkling.  The disagreement was what kind of food to get:  Joe wanted a big bucket of chicken and Edna wanted something daintier, like finger sandwiches and tea. </p>\
	<p>Finally, they consulted Derik. </p>\
	<ul class='options'>\
	<li><a href='switchbucket'>Bucket O' Chicken</a></li>\
	<li><a href='switchfinger'>Finger Sandwiches</a></li>\
	</ul>"
);

undum.game.situations['switchbucket'] = new undum.SimpleSituation(
"<p>'Um, a Bucket o' Chicken!' exclaimed Denise.</p>\
<p>Edna winced. 'Okay, but Joe, you know what chicken does to you.'</p>\
<p>Denise wondered what a bucket of fried chicken could do to someone.</p>\
<p>At the picnic, Joe and Denise plunged into the bucket of chicken like dogs digging in the dirt for a bone.  They made a tower of bones, that piled up like Lincoln Logs, and came tumbling down on the plate of a frowning Edna, who pecked nervously at the chicken in front of her. </p>\
<p>Denise soon learned what could go wrong with a basket of chicken.  Halfway through the picnic, Joe started looking panicky.  He kept turning his head left and right, and instead of sitting comfortably, he was standing, <a href='switchbucket2'>hunched a bit.</a></p>",
	{
	 enter: function(character, system, from) {
	 	             if (character.qualities.gender>-6){
			     system.setQuality("gender", character.qualities.gender -1);
				 }
            } 
	}
 );

undum.game.situations['switchbucket2'] = new undum.SimpleSituation(
"<p>Edna said, 'I think I saw a place over by the basketball courts,' and Joe shot off.</p>\
<p>'He doesn't do so well with fried chicken but can't admit it.  It's a problem -- male pattern stubbornness.  Thinks he's still a boy.'</p>\
<p>'Yeah, I know how he feels.'</p>\
<p>'What a strange thing to say,' said Edna.  'Now, Denise, I know you haven't had a lot of female role models in your life.' And with the edge of a napkin that she wet a bit with her water, she began to wipe grease from Denise's face.  'But I hope I can be a good one.'</p>\
<p>Denise shrugged and looked down.</p>\
<p>When she looked back up, Edna had lifted a grizzled thigh from the bucket of chicken, chomped down on the side of it, and let the juice run in a trickle down her chin.</p>\
<p>Denise grabbed a leg and followed her example, and they laughed and laughed.</p>\
<p>Eventually, Joe came back, looking a little pale, but relieved.</p>\
<p>Shall we, he said, and Edna and Denise <a href='switchrejoin'>shared secret winks.</a></p>"
);

undum.game.situations['switchfinger'] = new undum.SimpleSituation(
"<p>'Finger sandwiches,' said Denise in her most polite voice.</p>\
The finger sandwiches, in case you were wondering, contained not one finger.  And if you were disappointed, Edna was even more disappointed, because the only place they could find to pick up sandwiches was the sub shop, where the dainty little sandwiches were replaced with big six-inch subs, draped with meat and cheese and dripping with dressing.</p>\
<p>When they arrived at the picnic blanket, Denise had to help carry the food and the water cooler from the trunk.  They were amazed at how strong she was.  However, when she sat down <a href='switchfinger2'>something was clearly wrong.</a></p>",
	{
	 enter: function(character, system, from) {
	 	             if (character.qualities.gender<5){
			     system.setQuality("gender", character.qualities.gender +1);
				 }
            } 
	}
 );
 
undum.game.situations['switchfinger2'] = new undum.SimpleSituation(
"<p>'Denise, honey,' said Edna, tapping her knees.</p>\
<p>'Yes?' asked Denise.</p>\
<p>'Your legs.'</p>\
<p>Denise looked down at her legs.  She couldn't see anything particularly wrong with them.  They were long and strong and not a speck of dirt on them.</p>\
<p>'Put them together,' said Denise.  </p>\
<p>'You know,' said Joe, 'I see London, I see France.'</p>\
<p>Edna shot him a look.</p>\
<p>'What? I thought that was to help people remember. What? It helps me.'</p>\
<p>Denise blushed and at first sat Indian-style, but there was serious London and France going on there.  Finally, she bent her legs back and kept her knees together with the skirt lying flat and smooth.  She had seen girls sit like this a lot.   <a href='switchfinger3'>This was a lot of work.</a> </p>"
);

undum.game.situations['switchfinger3'] = new undum.SimpleSituation(
	"<p>After the meal, Denise couldn't help but try out her new found legs. She climbed some trees, chased some squirrels, and tried to do a cartwheel.  Again her skirt flopped down.</p>\
	<p>Edna went over to her.  'Yeah, cartwheels in a skirt, not such a good idea. Listen I have to teach you something very important that every girl should know.'</p>\
	<p>'Um, that's okay,' said Denise, squirming, 'You can tell me later.'</p>\
	<p>'Know it's really cool. Like a special secret.'</p>\
	<p>Denise felt sort of squiggly in her stomach, as if there were a goldfish swimming around in there. 'Nah, that's okay.'</p>\
	<p>'It'll help you remember about your underwear.'</p>\
	<p>'Fine,' said Denise.</p>\
	<ul class='options'>\
	<li><a href='switchboysecret'>[Boys, you don't need to know this and, Girls, you probably already know it.]</a></li>\
	<li><a href='switchgirlsecret'>[Girls, want to hear the secret? Boys, you can take the other choice.]<li></ul>"
);

undum.game.situations['switchboysecret'] = new undum.SimpleSituation(
	"<p>'Um, tell me later,' said Denise.  'Maybe when Joe's not around.'</p>\
	<p>'Oh, all right,' said Edna. 'Good idea.  Wouldn't want the secret to get out.'</p>\
	<p>Denise wondered if this was what she were in for, a lifetime of secrets from the world of girls.  Did that mean she already knew all the secret boy stuff?</p>\
	<p>What could it possibly be?  What would happen if she knew both? Somehow the idea made her intrigued and then nervous and <a href='switchrejoin'>then very, very confused.</a></p>",
	{
	 enter: function(character, system, from) {
	 	             if (character.qualities.gender>-6){
			     system.setQuality("gender", character.qualities.gender -1);
				 }
            } 
	}
 );

undum.game.situations['switchgirlsecret'] = new undum.SimpleSituation(
	"<p>'If you want to have fun and not worry about showing your underwear, all you need is a skort.' Said Edna with a smile.</p>\
	<p>'A skort?' said Denise.</p>\
	<p>'Yes, it's half skirt, half shorts.'</p>\
	<p>The mind of Derik inside of Denise was totally blown.</p>\
	<p>'Awesome,' said Denise, and high fived the woman who might just make <a href='switchrejoin'>an awesome Mom.</a></p>",
	{
	 enter: function(character, system, from) {
					             if (character.qualities.gender<5){
			     system.setQuality("gender", character.qualities.gender +1);
				 }
            } 
	}
 );


undum.game.situations['switchskate'] = new undum.SimpleSituation(
	"<h1>Ice Skating</h1><p>'But, I would like to go... Skating,' she said.  And they were off.</p>\
	<p>Joe and Edna were a sweet couple, straight out of the orphanage storybooks.  Joe was a bit plump and balding, wore an easy smile, looked to Edna often for approval of his slightly awkward behaviors.  Edna was tall and thin and pretty.  A worrier from the looks of those nails, but in a good way.  She had a somewhat fierce look she reserved for Joe's questionable driving choices but deep within a kindness that was <a href='switchskate2'>deep and true.</a></p>"
);

undum.game.situations['switchskate2'] = new undum.SimpleSituation(
	"<p>Their trip to the Skating rink was without incident, aside from some honking horns, but to be honest, Denise was travelling as though in a dream.  The sudden shock of waking up in a girl's body had withdrawn like the tide, and she was left in the backseat beaming, a warmth welling up in her, at being able to walk.</p>\
	<p>Edna and Joe were busy bickering over whether or not Edna should skate or just Joe, as Joe was clearly a bit unsteady on skates.  Derik who had never skated before in his life was as Denise tying one his skates with confidence.  He pulled the ends of the bow with a firmness of a soldier suiting up for battle and he stood <a href='switchskate2a'>and he walked.</p>"  
);


undum.game.situations['switchskate2a'] = new undum.SimpleSituation(
		"<p>Time for skating. What should Denise try?</p>\
		<ul class='options'>\
		<li><a href='switchskatespin'>A graceful twirl on the ice?</a></li>\
		<li><a href='switchskateshower'>Zooming around full speed ahead and spraying ice on Joe?</a></li>\
		</ul>"
);

undum.game.situations['switchskateshower'] = new undum.SimpleSituation(
	"<p>No, Denise had never skated before, but somehow she felt like she could.  With all her might, she pushed off from the wall and zoomed around the rink at full speed, turning each corner like a pro.  His ankles didn't even buckle. It was astounding. With his ease and might, he looked like Mario Lemeiux or the Great One.</p>\
	<p>As he finished his third round, he spied Joe leaning up against the wall chatting with Edna.  As a wicked smile stretched across his face, he sped toward Joe at full blast. Joe didn't <a href='switchskateshower2'>see him coming.</a></p>",
	{
	 enter: function(character, system, from) {
	 	             if (character.qualities.gender>-6){
			     system.setQuality("gender", character.qualities.gender -1);
				 }
            } 
	}
);	

undum.game.situations['switchskateshower2'] = new undum.SimpleSituation(
    "<p>Just before he was about to ram into Joe, he turned sharply, putting all his weight on his skates, sending a glorious spray of ice all over Joe.</p>\
	<p>Unfortunatley, the spray was a bit too much for Joe who toppled over.  This was terrible. What could be worse than knocking over an Almost before they had signed on the dotted line? He would never be adopted.</a><p>\
	<p>'Um, you okay?' asked Denise, <a href='switchskateshower3'>skating over to help him up.</a></p>"
	);
	
	
undum.game.situations['switchskateshower3'] = new undum.SimpleSituation(
	"<p>Suddenly, from behind him came another shower over ice, spraying all over him and Joe. 'Oh my gosh,' said Edna, 'that was hilarious.' And Joe gave a red-cheeked grin as well, tossing a clump of shaved ice back at Edna.</p>\
	<p>After seeing she had only brusied Joe's bum and his ego and getting a huge high five from Edna, she relaxed.</p>\
	<p>Denise was beaming.  <a href='switchrejoin'>Legs were amazing.</a></p>"
);

undum.game.situations['switchskatespin'] = new undum.SimpleSituation(
	"<p>No sooner did her step on the ice than he realized that he had no idea what he was doing, but then came the breeze.  Off from a distant corner of the skating rink, a breeze of light and color swirled toward him, and not doubting that this was Mrs. Wobbles' work, he let it carry him onto the ice as he could now, and without a doubt magically skate.</p>\
	<p>Joe and Edna turned to watch this young girl, gracefully swirling about.  Edna gave Joe a comical whack on the arm, and he was soon stumbling and scrabbling out onto the ice <a href='switchrejoin'>to join Denise.</a></p>",
	{
	 enter: function(character, system, from) {
	             if (character.qualities.gender<5){
			     system.setQuality("gender", character.qualities.gender +1);
				}
            } 
	}
);

//Add reference to what they chose 
undum.game.situations['switchrejoin'] = new undum.SimpleSituation(
	"<p>The day passed with ease and laughter. They were amazed at how much Denise could eat at the burger place after their just a short adventure.  To top they day off, they brought her to a doll shop for her <a href='switchhackpredoll'>to pick out a doll.</a></p>"
);

undum.game.situations['switchhackpredoll'] = new undum.SimpleSituation(
	"<p>But when [cough, hack, hack] -- <a href='./switchhack2' class='once'>after they were.</a></p>",
	 {  
	   enter: function(character, system, from) {
      //system.writeSound(character, 'start');
	},
         actions: {
         
			'switchhack2': function(character, system, action) {
			var hacktext2=["<br/>[blech, blagh, blurgh]\
                          <p> 'How could we burn your ship?' asked Mildred now getting up in the pirate's face. 'We're just three children lying in the sand over here with you.'</p>\
							<p>'My, my, you can talk,' the great pirate wheeled around, his wooden foot still pointing the same direction as he pivoted.   He was close enough to dice her with his sword but seemed to hold back when he saw it was a girl.</p> \
							<p>'Then perhaps ya can explain why there's magma burning up my ship.'</p>\
							<p>Leroy was going to explain that it was lava, but held his tongue. 	</p>\
							",
							"<br/>[burrrrrp]\
							<p>Outside, the sunny street in Silver Lake was somehow chilly.  It was nearly spring, but the \
							air still had a crisp little curl on it, a frost lick, and a wind.  <em>That would be the Santa Ana wind, but more on that later.</em>  The boys' poorly patched\
							wind-breakers were too thin to be of much help.</p>\
							<p>As they walked up the steep hill it became clear that the boy in the wheelchair\
							was headed in the same direction.  Stevie overheard the woman say, 'Now Derik, when you\
							get to Mrs. Wobbles', I expect you to be on your best behavior.  This has to be your\
							last placement until--' </p>\
							<p>'I know, I know.'</p>\
							<p>Until what? thought Stevie. And did she just say 'Wobbles'?  He couldn't be sure.</p>\
						  ",
							"<br/>[hack, hack, hackity hack]\
							<p>Ichel and Juan, tangle-haired younger sister and spiky haired older brother, lay down on the rug, flipping through their Life Book.  A Life Book is like a big scrapbook of your life story so far. You may have never heard of one of these, but many of the children living in the Tangerine House had one, and it went on with them when they were adopted.  I believe, these are some of the most important books in world, after the Book of the Lost, of course. </p>\
						  "];
			var choose=system.rnd.randomInt(0,2);;
			system.write("<p><em>"+hacktext2[choose]+"</em></p><br/>");
			system.write("<p>Oh, dear. That was from the wrong story all together.</p>\
			<p>Okay, this is becoming a bigger problem than I thought. But don't worry. <a href='switchdoll'>I think I'm back now.</a></p>");
			//system.writeSound(character, 'switchhack');
			}
		}
	}
);


//Doll Shop Section begins Here


undum.game.situations['switchdoll'] = new undum.SimpleSituation(
	"<h1>Ana Crony Girls Doll Shop</h1><p>The Ana Crony Girls Doll Shop was not just any doll shop.  It was the most high end doll shop in the country, and this store at the most hoity-toity of outdoor shopping promenades was their flag ship.</p>\
	<p>The store was full to the brim with girls in flouncy dresses, sparkly shoes, and hair ribbons who'd fit right in next to the dolls on the shelves.  Girls who'd been accustomed to being primped and pampered and waited on.  Girls who were basically living dolls to their moms and dads, treasures to be decorated and adored.  Girls that made the Derik side of Denise <a href='switchdoll2'>want to puke.</a></p>"
);
 
undum.game.situations['switchdoll2'] = new undum.SimpleSituation( 
	"<p>Of course, at the store you didn't just buy a doll.  Dolls came with birth certificates, detailed hospital paper work listing their birth weight and height, resumes and family trees, citizenship papers, and all sorts of other documents.  Not only did each doll have a name, she had her own backstory and her future life story that was thicker even than a Harry Potter book (not the first ones, <a href='switchdoll3'>more like Book 5!).</a></p>"
);

undum.game.situations['switchdoll3'] = new undum.SimpleSituation(
	"<p>The store didn't even call it buying a doll.  No, that would be too crass, too petty. They called it adopting a doll.  The irony was not lost on Denise.</p>\
	<p>Choosing a doll was supposed to be like choosing a soulmate or a best friend.  A doll was supposed to be not just a toy but a partner for life, someone to live with and live up to, a sign of what you wanted to be, of what you could be, of <a href='switchdoll4'>how you saw yourself.</a></p>"
);

undum.game.situations['switchdoll4'] = new undum.SimpleSituation(
	"<p>Both his Derik side and his Denise side found the whole idea ridiculous.  Adopting a doll! A doll with birth records!  None of his action figures came with lengthy stories.   Major Markup did not come with a novel! Agent Orange did not have his whole life written out.  (Actually, they did.  The dolls -- er, action figures had their own movies and tv shows, chapter books, and comic books and the works, but we'll let him think this for now.)</p>\
	<p>'You can have whatever girl you like,' said Joe, beaming with generosity and pride.</p>\
	<p>'Or you can play the trading card game,' added Edna, picking up a deck.</p>\
	<ul class='options'>\
	<li><a href='switchdollgame'>Play the card game</a></li>\
	<li><a href='switchdollshop'>Just choose a doll</a></li>\
	</ul>",
	{
	 enter: function(character, system, from) {
			     character.sandbox.readstory=true;
            } 
	}
 );


// Insert the Card game
undum.game.situations['switchdollgame'] = new undum.SimpleSituation(
        "<h1>The Ana Chrony Doll Trading Card Game</h1>\
        <p>In a desperate bid at directing boy customers into the Ana Chrony Doll Store, known as the most expensive doll 'adoption' shop on Earth, one employee -- who was fired shortly after the idea -- suggested the company try to target boys with an original trading card game.  The idea was to make it fun to collect cards about the various dolls and then to pit them against each other in combat.  It was one of those classic ideas.  Classically bad.  Sort of like giving someone green beans when they ask for jelly beans.  <a href='switchdollplay'>Play the game.</a></p>"
		);
		
		
undum.game.situations['switchdollplay'] = new undum.SimpleSituation(
      "<p>Let the game begin!",		
		{
		enter: function(character, system, from) {
	var mypower= Math.floor((Math.random()*10)+25);
	var yourpower= Math.floor((Math.random()*10)+25);
   attack = function(attacknumber) {
	var x=attacknumber;
	var vari1 = x;
    // Now, "eval()" uses vari1`s value to create another variable, having this name
    eval("var loss = you[0].attack"+vari1+"points;");
	eval("var move = you[0].attack"+vari1+";");
	eval("var sound= you[0].attacksound"+vari1+";");
	//Check to see if the person has enough power.
//	system.write( "<p>You have "+ you[0].power + " power</p>");
//	system.write("<p>That attack costs "+ loss + " power</p>");
	if (you[0].power<loss){
		$("#narration").html("<p>You do not  have enough Gurl Power for that attack!</p>");
	    return;
     }
	$("#narration").html("<p><em>"+ sound +"</em>! You use " + move + "!</p>");
    $("#ending").html("<p align='center'></p>");
	//damage should be Random number 1-loss -- check living will for code
	var damage= Math.floor((Math.random()*loss)+1);
	player[3].hitpoints=player[3].hitpoints - damage;
	you[0].power=you[0].power-loss;
	$("#hitpoints").html(player[3].hitpoints+ "<progress max='25' value=" +player[3].hitpoints + "><div class='progress-bar'><span style='width: 80%;'></span></div></progress>");
	$("#powerpointsyou").html(you[0].power + "<progress max='35' value=" +you[0].power + "><div class='progress-bar'><span style='width: 80%;'></span></div></progress>");
	if (player[3].hitpoints<=0){
	// or if the computer is out of power points
	$("#ending").html("<p>"+you[0].name+" has soundly defeated " +player[3].name +"! Your historical girl -- or  is it unhistorical girl? -- has thoroughly crushed another! Well done!</p>");
	 $('#attack1').attr("disabled", true);
	  $('#attack2').attr("disabled", true);
     if (character.sandbox.readstory==false){
		    system.write("<p>Games are fun. Why not try again? Avoid the story.</p>\
			<ul class='options'>\
			<li><a href='index.html'>Go back to the start of the story to try again.</a></li>\
            <ul>");
			} else {	  
	system.write("<ul class='options'>\
	<li><a href='switchdollshop'>Time to choose a doll.</a></li>\
	</ul>");
	}
	}
	 else if (player[3].power<=player[3].attack1points){
	// or if the computer is out of power points
	$("#ending").html("<p>Way to go!  "+player[3].name+" does not have enough Gurl Power to fight anymore. " +you[0].name +" wins! </p>");
	 $('#attack1').attr("disabled", true);
	  $('#attack2').attr("disabled", true);
	  if (character.sandbox.readstory==false){
		    system.write("<p>That felt good, I know. Games feel good. Play again and avoid reading the Book of the Lost. It's mostly hot air.</p>\
			<ul class='options'>\
			<li><a href='index.html'>Go back to the start of the story to try again.</a></li>\
            <ul>");
			} else {
	system.write("<ul class='options'>\
	<li><a href='switchdollshop'>Time to choose a doll.</a></li>\
	</ul>");
    }
	}
	else  { 
	//adds a pause to make it seem like the computer is thinking
	 $('#attack1').attr("disabled", true);
	  $('#attack2').attr("disabled", true);
	setTimeout(function(){
	if (player[3].power>=player[3].attack2points){
		var vari2 = 2;
		}
	else {
		var vari2 = 1;
	 }
	eval("var loss2 = player[3].attack"+vari2+"points;");
	//damage2 should be Random number 1-loss -- check living will for code
	var damage2= Math.floor((Math.random()*loss2)+1);
	you[0].hitpoints=you[0].hitpoints-damage2;
	player[3].power=player[3].power-loss2;
	eval("var move2 = player[3].attack"+vari2+";");
	eval("var sound2= player[3].attacksound"+vari2+";");
	$("#narration").html("<p align='right'><em>"+ sound2 +"</em>! I use " + move2 + "!</p>");
	$("#hitpointsyou").html(you[0].hitpoints+ "<progress max='25' value=" +you[0].hitpoints + "><div class='progress-bar'><span style='width: 80%;'></span></div></progress>");
	$("#powerpoints").html(player[3].power+ "<progress max='35' value=" +player[3].power + "><div class='progress-bar'><span style='width: 80%;'></span></div></progress>");
	$('#attack1').attr("disabled", false);
	$('#attack2').attr("disabled", false);
	if (you[0].hitpoints<=0){
		$('#attack1').attr("disabled", true);
		$('#attack2').attr("disabled", true);
		$("#ending").html("<p>Nah-Nah, Boo-Boo! " + player[3].name + " has truly defeated " +you[0].name  +"! In your face!</p>");
		if (character.sandbox.readstory==false){
		    system.write("<p>That was sad. Losing is hard. Of course, no one ever loses when they read a heartfelt tale.</p>\
			<ul class='options'>\
			<li><a href='index.html'>Go back to the start of the story to try again -- or maybe read the story.</a></li>\
            <ul>");
			} else {
	    system.write("<ul class='options'>\
			<li><a href='switchdollshop'>Time to choose a doll</a></li>\
			</ul>");
			}
			}
	else if (you[0].power<you[0].attack1points){
		// if you are out of power points
		$('#attack1').attr("disabled", true);
		$('#attack2').attr("disabled", true);
		$("#ending").html("<p>Sorry, you have lost. Wiped out, exhausted, weeping, "+you[0].name+" does not have enough Gurl Power to fight anymore. " +player[3].name +" wins! </p>");
		if (character.sandbox.readstory==false){
		    system.write("<p>Frustrating. Isn't it?  I recommend reading the story, but you can do what you'd like.</p>\
			<ul class='options'>\
			<li><a href='index.html'>Go back to the start of the story to try again.</a></li>\
            <ul>");
			} else {
		system.write("<ul class='options'>\
			<li><a href='switchdollshop'>Time to choose a doll.</a></li>\
			</ul>");
          }
		  }
	    else {
		$("#ending").html("<p align='center'>Your turn.</p>");
		}
	}, 3000);
	} 
	return x;
};
   
   // Now for the cards
  //eventually randomize hitpoints and power
var card = new Array ();


card[0]=
	{id: 0,
	name:"Mol",
	locale: "Chicago",
	era: "1920s",
	image:"mol",
	description:"A rum-runner, gangster gal with a heart the color of big bathtub red. But when she wasn't mixing drinks, she was known as the Florence Nightingale of the Ganglands, treating wounds with bootleg booze, in other words, alcohol that was forbidden. In World War II, she pioneered the use of alcohol to sanitize cut, clean instruments, and decrease acne.",
	attack1:"Bootleg Bash",
	attacksound1:"Bam Bam",
	attack1points: 3,
	attack2: "Kill'em with Kindness",
	attacksound2:"Simper Simper",
	attack2points: 11,
	hitpoints: 21,
	power:42
	};
	
card[1]=
	{id: 1,
	name:"Potawanyme",
	locale: "Great Lakes",
	era: "1700s",
	image:"potawanyme",
	description:"Daughter of the chief of the Sioux Indians, she loved to ride free, shoot buffalo, and wrestle bears but was most famous for sewing the first American Flag out of leaves and sticks and tear drops, a work of art only discovered when the settlers evicted her tribe to build a Native American-themed shopping mall.",
	attack1:"Bear Hug",
	attacksound1:"Ska-weeze",
	attack1points: 4,
	attack2: "3 Twig Cross-stitch",
	attacksound2:"Knitpurl",
	attack2points: 12,
	hitpoints: 20,
	power:42
	};
	
	
card[2]=
	{id: 2,
	name:"Jazmine",
	locale: "Mississippi",
	era: "1850s",
	image:"jazmine",
	description:"Born a slave on a plantation, Jazmine became a hero when she escaped through the Underground Railroad to a Midewestern whistle-stop town.  Later, she was railroaded into selling her story to a motion picture company who fasttracked the film into theaters.  Ironically, she would become an R&B legend best known for her performances on a popular dance show with a train theme.",
	attack1:"The Electric Slidekick",
	attacksound1:"Shazbot",
	attack1points: 7,
	attack2: "The Bumpity Bump",
	attacksound2:"BumpaBumpa",
	attack2points: 13,
	hitpoints: 19,
	power:42
	};
	
card[3]=
	{id: 3,
	name:"Antonia",
	locale: "Kansas",
	era: "1860s",
	image:"antonia",
	description:"This prairie settler snuck out West, disguised as a boy.  She was such a good boy she was hired to give lessons in spitting, farting, and acting goofy.  When she grew up, the daughter of the Mayor of Kansas City fell in love with her, so Antonia had to spend the rest of her life avoiding her calls.",
	attack1:"Speed Spitting",
	attacksound1:"Putooey",
	attack1points: 4,
	attack2: "Call Ignoring",
	attacksound2:"Ring Ring",
	attack2points: 14,
	hitpoints: 18,
	power:42
	};
	
card[4]=
	{id: 4,
	name:"Donna",
	locale: "New York",
	era: "1970s",
	image:"donna",
	description:"Donna loves the night life, she loves to boogie, and she loves to study international business. Although twin disco balls twinkle in her eyes, she eventually finds her true love is molded plastic. She would one day develop a line of dolls that people will pay any price for.",
	attack1:"Boogie Beam",
	attacksound1:"Cowbell Cowbell",
	attack1points: 6,
	attack2: "Merchandising Mayhem",
	attacksound2:"Ka-Ching",
	attack2points: 28,
	hitpoints: 30,
	power:60
	};
	
card[5]=
	{id: 5,
	name:"Su",
	locale: "Fresno",
	era: "1850s",
	image:"su",
	description:"Su's parents came from China or Japan or Korea.  She eats noodles, can write words that look like pictures, and wears Hello, Kitty on everything.  Her father is building transcontinental railroad.  Her mother runs a successful Internet start-up. She grows up to cure five forms of cancer and to publish a very controversial book on parenting.",
	attack1:"Calligraphy Stroke",
	attacksound1:"Scratchety Scratch",
	attack1points: 3,
	attack2: "Tiger Momming",
	attacksound2:"Dissss-approve",
	attack2points: 16,
	hitpoints: 16,
	power:42
	};
	
	card[6]=
	{id: 6,
	name:"Evelyn",
	locale: "Atlanta",
	era: "1860s",
	image:"evelyn",
	description:"Granddaughter of the biggest plantation owner in the South, Evelyn spends her time doing nice things for the servants, like teaching them to read, straightening their hair, and showing them how to laugh with their teeth tight. When she grows up, she founds an organization that gives scholarships to girls who choose not to go to college so they can perform authentically in historical reenactments.",
	attack1:"Condescending Kicks",
	attacksound1:"Keeya",
	attack1points: 5,
	attack2: "Philanthropic Punch",
	attacksound2:"Shindig",
	attack2points: 17,
	hitpoints: 15,
	power:42
	};
	
	card[7]=
	{id: 7,
	name:"Skye",
	locale: "Beverly Hills",
	era: "1980s",
	image:"skye",
	description:"Although she never quite accepted the rich life growing up in one of the wealthiest neighborhoods in Los Angeles, Skye finds that when the sorority she joins is having trouble developing a theme for their philanthropy project, her life as a socialite gives her the tools to save the day. When the local school doesn't have enough money for math books, she lets the students use trigonometry and differential equations to organize her closet.",
	attack1:"Silver Spooning",
	attacksound1:"Scoop Scoop",
	attack1points: 3,
	attack2: "Accessorizing Ambush",
	attacksound2:"Matcha Match",
	attack2points: 18,
	hitpoints: 25,
	power:42
	};

card[8]=
	{id: 8,
	name:"Kat",
	locale: "Omaha",
	era: "1930s",
	image:"kat",
	description:"Born in the great depression, Katherine earns her nickname Kat by selling kitties she has trained to sing.  When she grows up, she becomes the first woman to fly across the Pacific.  However, her plane went missing shortly after her male copilot asked her when she was going to start serving coffee and tea to the passengers. Her last words on the flight recorder were reported to be, 'Reeeerrrrr!'",
	attack1:"Kitten Choral Concert",
	attacksound1:"Meeeeeeeowr",
	attack1points: 6,
	attack2: "Sha-right Shove-off",
	attacksound2:"Sha-ov",
	attack2points: 19,
	hitpoints: 13,
	power:42
	};
	
card[9]=
	{id: 9,
	name:"Sonia",
	locale: "California",
	era: "1840s",
	image:"sonia",
	description:"Born on a ranch in Northern Mexico (aka California), Sonia's family immigrated to the United States illegally by remaining in California when it became the part of the US territories. She worked her way through school by playing the spicy, sassy friend on tween comedies, making it all the way through law school.  She would later end up on the Supreme Court where she spent most of her time trying not to roll her eyes at ridiculous things the other justices said.", 
	attack1:"Opposing Opinioning",
	attacksound1:"Disssssent",
	attack1points: 12,
	attack2: "Juris Prudery",
	attacksound2:"Ruuuuling",
	attack2points: 26,
	hitpoints: 15,
	power:42
	};
 	// shuffle the deck
card.shuffle();
var player = new Array ();
 
 // assign the player 3 cards
 player[0] = card.pop();
 
 player[1] = card.pop();
 
 player[2] = card.pop();
 
// assign the computer the remaining card
 player[3] = card[0];
 player[3].power = yourpower;
 
 system.write("<br/><center><font size='18'>" + player[3].name + "</font> is my card. She's from the "+ player[3].era + ".</center>");   //prints "the first element." 
 system.write("<center>Your cards are: <span id='cardname0'>" + player[0].name + "</span>, <span id='cardname1'>" + player[1].name + "</span>, <span id='cardname2'>" + player[2].name + "</span><br/>You have " + mypower + " Gurl Power Points</center>");
 
 var you = new Array ();
 you[0]="";
 var x;
 
 
  //set card
 	setCard = function (x) {
	var selection=x;
    you[0] = player[x];
	you[0].power = mypower;
	eval("var cardchosen = '#cardname" + x + "';");
	$(cardchosen).animate({fontSize:"3em"});
	$("#messagecard").html("<center><table width=500px ><tr><td width='242px' style='padding:1'><center><h2>"+you[0].name+"</h2><img src='media/games/tutorial/images/switchimages/"+you[0].image+".jpg'></center></td><td width='242px' style='padding:1px'><center><h2>"+player[3].name+"</h2><img src='media/games/tutorial/images/switchimages/"+player[3].image+".jpg'></center></td></tr><tr valign='top' id='description' style='font-size:11pt; line-height:14pt'><td >"+you[0].description+"</td><td>"+player[3].description+"</td></tr><tr><td><strong>Attack 1:</strong> "+you[0].attack1+"<br/>(" +you[0].attack1points + " points) <button type='button' id='attack1' value=1 onclick='attack(value)'>Attack 1</button><br/><strong>Attack 2:</strong> "+you[0].attack2+"<br/>(" +you[0].attack2points + " points) <button type='button' id='attack2' value=2 onclick='attack(value)'>Attack 2</button></td><td><strong>Attack 1:</strong> "+player[3].attack1+"<br/>(" +player[3].attack1points + " points)<br/><strong>Attack 2:</strong> "+player[3].attack2+"<br/>(" +player[3].attack2points + " points)</td></tr><tr><td><strong>Hit Points:</strong> <span id='hitpointsyou'>" + you[0].hitpoints + "<progress max='25' value=" +you[0].hitpoints + "><div class='progress-bar'><span style='width: 80%;'></span></div></progress></span></td><td><strong>Hit Points:</strong> <span id='hitpoints'>"+ player[3].hitpoints + "<progress max='25' value=" +player[3].hitpoints + "><div class='progress-bar'><span style='width: 80%;'></span></div></progress></span></td></tr><tr><td><strong>Gurl Power:</strong> <span id='powerpointsyou'>" + you[0].power + "<progress max='35' value=" +you[0].power + "><div class='progress-bar'><span style='width: 80%;'></span></div></progress></span></td><td><strong>Gurl Power:</strong> <span id='powerpoints'>" + player[3].power + "<progress max='35' value=" +player[3].power + "><div class='progress-bar'><span style='width: 80%;'></span></div></progress></span></td></tr><tr><td colspan=2 id='narration'></td></tr><tr><td colspan=2 id='narration'></td></tr><tr><td colspan=2 id='ending'>Choose your attack!</td></tr></table></center>");
	};
 
 
 //Display the computer card
 system.write("<center><table id='messagecard' width=450px  style='border-spacing: 5px;border-collapse: separate; line-height:22px'><tr><td>" + player[0].name + "</td><td>" + player[1].name + "</td><td>" + player[2].name + "</td></tr><tr><td>era: " + player[0].era + "</td><td>Era: " + player[1].era + "</td><td>Era: " + player[2].era + "</td></tr><tr><td><button type='button' onclick='setCard(0)'>Select this card</button></td><td><button type='button' onclick='setCard(1)'>Select this card</button></td><td><button type='button' onclick='setCard(2)'>Select this card</button></td></tr></table></center>");
 // Display the player's cards in a table at the bottom row is a button to choose to play that card. 
 //Will need to refresh screen after this game.
  

			},
		}
        );





undum.game.situations['switchdollshop'] = new undum.SimpleSituation(
	"<p>After combing the store, Denise's eye was caught by the glint of metal.  It was not jewelry, not a sparkle from a dress, a buckle, or a show, but something else.  Here was Willamina, a smart, happy looking doll, bright cheeks and shining eyes, hair pulled back in a sassy ponytail, and a wheelchair.</p>\
	<center><img src='media/games/tutorial/images/girldoll2_440.png'></center>\
	<p>Derik, or Denise, was dumbstruck.  The only word he could <a href='switchdollshop2'>think of was: home.</a></p>" 
);

undum.game.situations['switchdollshop2'] = new undum.SimpleSituation(
	"<p>'Denise.  Denise?' A voice came from behind her. It was Edna.</p>\
	<p>'Oh, I think she's found one,' said Joe, knocking over a tall pyramid of boxes in a fancy display, much to the irritation of the shop staff, who fussed and fumed about every detail of the store.</p>\
	<p>'These are children!' said one of them in an angry whisper.</p>\
	<p>'Joe!' <a href='switchdollshop3'>scolded Edna.</a></p>" 
);

undum.game.situations['switchdollshop3'] = new undum.SimpleSituation(
	"<p>But Denise tuned them out once more.  Willamina Washington: born in the Great Depression, a bout with polio had robbed her of her ability to walk, and like President Franklin D. Roosevelt she was bound to a wheelchair for her remaining days.  In fact, she was the one who gave him the idea for his great plan, the New Deal.  During World War II, she would take a job in a factory, riveting airplane wings together.  She could not walk, but she could <a href='switchdollshop4'>help others to fly.</a></p>" 
);

undum.game.situations['switchdollshop4'] = new undum.SimpleSituation(
	"<p>In the 1970s, as an older woman, she fought for women's rights and for the disabled.  In the 1990s, she helped write the Americans with Disabilities Act, a bill that would force businesses and restaurants and schools to make their establishments accessible to wheelchairs. In 2010, she would go into space <a href='switchdollshop5'>as an astronaut.</a></p>"   
);

undum.game.situations['switchdollshop5'] = new undum.SimpleSituation(
	"<p>If it had been any other doll, or any other day, or if he had still been Derik he would have made fun of this doll.  An 80-year-old astronaut? Who'd ever heard of such a thing. But today was different. All he could say was</p>\
	<p><a href='switchdollshop6'>Yoopers.</a></p>" 
);

undum.game.situations['switchdollshop6'] = new undum.SimpleSituation(
	"<p>'Is that the doll you want?' asked Edna, leaning down beside her.  Edna's perfume washed over Denise like a hug.</p>\
	<p>'What an excellent choice! A doll in a wheelchair! Amazing!' said Joe. 'I wonder what happened to her.  I wonder if she could get an operation and be able to walk again.  I think they have a hospital in this store.  Maybe this is just one of <a href='switchdollshop7'>the broken ones.'</a></p>" 
);

undum.game.situations['switchdollshop7'] = new undum.SimpleSituation(
	"<p>At that, Denise dropped the doll and ran down the escalator and out the front door into a stream of people walking back and forth across the shopping pavilion brushing past her, jostling her this way and that like a rough current.</p>\
	<p>'Denise! Denise!' came a cry from <a href='switchdollshop8'>far behind her.</a></p>" 
);

undum.game.situations['switchdollshop8'] = new undum.SimpleSituation(
	"<p>Soon, all Denise could hear was her own breath in her ears.  Tears blocked the sight of the people passing who were stepping on her shoes and knocking into her legs, almost as if they didn't see her there.  As she crouched down, legs were all she could see: in stockings, slack, and jeans, shorts, knee socks, and trousers of every kind.</p>\
	<p>'Denise! Denise! Joe, <a href='switchdollshop9'>there she is.'</a></p>" 
);

undum.game.situations['switchdollshop9'] = new undum.SimpleSituation(
	"<p>It was Joe who yanked her from the tide of people, pulled her up to his shoulder, and rested her down beside him and Edna on a nearby bench.</p>\
	<p>'I want to go home,' said Denise, the last of the tears running down. 'Would that be all right?'</p>\
	<p>Edna and Joe exchanged a look that said they had no idea what was going on but, <a href='switchreturn'>of course, consented.</a></p>" 
);

// Returning back home

undum.game.situations['switchreturn'] = new undum.SimpleSituation(
	"<p>The drive back was very different from the drive there, although Edna still shot glares at Joe every time he jerked the wheel or passed someone for no reason.  Despite some kids music Joe had popped into the CD player, the mood in the car was now totally glum.  Denise spent the trip staring not out the window but at Derik.  Tears had reddened his cheeks, her eyes were puffy from crying, but in the window, she saw his face half-reflected, <a href='switchreturn1'>lost and alone.</a></p>",
		{
	exit: function(character, system, to){
		if (character.qualities.poetry>6){
	system.write("<p>But something inside her was propping her up, making her feel like the distance between her and that crying boy in the reflection was not so great.  Did not matter so much.  And then she realized that it was that poem she had read.  Remembering its gentle lines drawing her into a hug, she took a deep, shaky breath.</p>");
	   }
	  }
	 }
);	 

undum.game.situations['switchreturn1'] = new undum.SimpleSituation(
	"<p>Beside her was a gift from the Sheepheads.  To make up for the doll fiasco, they had decided to buy her something else: shoes. Because nothing says 'We're not sure how we upset you, but we feel real bad about it' like a new pair of shoes.</p>",
		{
	enter: function(character, system, from){
		if (character.qualities.gender<2 && character.qualities.gender>-2){
			system.write("<p>Denise feared she hadn't been delicate enough for Joe or tough enough for Edna.  They had bought her something, but was it a parting gift or a sign of approval, Denise couldn't tell.  For whatever reason, Joe and Edna decided new Sketchers would be a treat. Adults think in all sorts of strange ways, reflected Denise, and they are largely unreadable when they are upset or afraid.</p>");
			}
		else if (character.qualities.gender<-2) {
			system.write("<p>They seemed to have decided she was a tough girl. Denise would be all right, they remarked. She'd shake it off. Did they have any idea how fragile she felt? Any clue how much she just wanted a hug? Doubtful. Instead, they wanted to buy her something. Why, she couldn't tell. So following Edna's suggestion, they got her brand new Chuck Taylors.</p>");
		}
		else {
			system.write("<p>After the doll store incident, Denise had seemed so upset, and Joe seemed to be feeling to blame.  Denise feared she had jeopardized everything. He was treating Denise like some fragile flower: offering to buy her earrings or a princess dress, but nothing appealed to Denise.  And that's when he saw the sparkly pink boots.</p>");
		}
			system.write("<p>They might not be a big deal to you or me, especially since I am a book, but to a boy who had been wearing special orthopedic shoes all his life, normal shoes were <a href='switchreturn2'>quite a treasure.</a></p>");
	}
  }
);

 
undum.game.situations['switchreturn2'] = new undum.SimpleSituation(
	"<p>When they arrived at the Tangerine House, Mrs. Wobbles met them at the curb.",
	{
	enter: function(character, system, from){
		if (character.qualities.gender<=0){
			system.write("She thanked the Sheepheads who said, 'No prob. This was awesome.  Totally awesome.  You're a good kid.'</p>\
			<p>'Denise,' said Joe, leaning over beside the girl, 'That was a blast, and we think you're the best. You're kinda like a younger version of Edna. You even belch the same. Wanna do this again?' Joe's eyes were welling up.</p>\
			<p>Denise wanted to say yes, but instead said, 'Maybe.'</p>\
			<p>After a fist bump from Edna and a backslapping hug from Joe, Denise watched them as they got back into the station wagon and pulled away with a jerk and a screech.");
			}
		else{
			system.write("She thanked the Sheepheads who said, 'No, no, thank you! We had a marvelous time.  Such a precious little girl.'</p>\
		<p>'Denise,' said Edna, kneeling down beside the girl. 'We had a wonderful time with you.  Such a sweetie. Seems like you and Joe are cut from the same cloth. Could we do it again?'</p>\
		<p>Denise wanted to say yes, but instead said, 'Maybe.'</p>\
		<p>After a hug from Edna and kind of awkward lean from Joe, Denise watched them as they got back into the station wagon and pulled away with a jerk and a screech.</p>");
			}
			system.write("<p>Denise could almost see Edna whacking Joe in the arm for that one. And she <a href='switchreturn3'>smiled to herself.</a></p>");
		}
	}
);

undum.game.situations['switchreturn3'] = new undum.SimpleSituation(
	"<p>On the swing on the porch of the Tangerine House, Denise sat beside Ms. Wobbles.  They spent nearly twenty minutes in complete silence.'</p>\
	<center><img src='media/games/tutorial/images/porch_440.png'></center>\
	<p>'It's not everything I thought it would be,' Denise finally said, breaking the silence.</p>\
	<p>'It never is.'  Ms. Wobbles showed her bright large teeth as she grinned.  They passed a few more minutes in silence with the cicadas and crickets.   Ms. Wobbles slapped at a mosquito.</p>\
	<p>'Do you think I might go back, Mrs. Wobbles, <a href='switchreturn4'>to the way I was?'</a></p>"
);

undum.game.situations['switchreturn4'] = new undum.SimpleSituation(
	"<p>The great woman, turned her loving eyes on the girl.  'Is that what you want?'</p>\
	<p>Denise shrugged.</p>",
	{
	enter: function(character, system, from){
		if (character.qualities.gender<=0){
			system.write("<p>'Wouldn't be able to walk.  But you could dress however you want, nobody nagging you that you aren't acting like proper girl.'</p>");
		}
		else{
		system.write("<p>'Wouldn't be able to walk.  Would be a stinky, yucky boy again.'</p>");
		}
			system.write("<p>Denise <a href='switchreturn5'>looked away. 'Yeah.'</a></p>");
	}
	}
);

undum.game.situations['switchreturn5'] = new undum.SimpleSituation(
	"<p>Denise could see herself when she first arrived at the house, a boy struggling to get in and out of that wheel chair -- but still being Derik the boy knew, loving all those boy things, boy games, boy thoughts.  But then, she could also see herself happily running into the doll store and then in tears, confused, conflicted, running out of the store.  What would be better?  What did she really want? </p>\
	<p>'It's a choice between leaving tomorrow or the next day and staying here for who knows how much longer.  But, of course, that's not all there is to it....'</p>\
	<p>Denise nodded, staring <a href='switchreturn6'>off at the street.</a></p>"
);

undum.game.situations['switchreturn6'] = new undum.SimpleSituation(
	"<p>Ms. Wobbles put her thick arm around Denise's shoulder. 'Well, there's something of Derik's by the curb.  I wasn't sure if we needed it or not.'</p>\
	<p>Denise smiled, gave Mrs. Wobbles a hug only to get a bear hug right back.</p>\
	<p>But the moment had come for Derik, or was it now Denise, to choose.</p>\
	<ul class='options'>\
	<li><a href='switchreturn7a' onClick='_gaq.push([\"_trackEvent\",  \"Switcheroo\", \"FinalSwitch\", \"Boy\"]);'>Go and get the wheel chair.</a></li>\
	<li><a href='switchreturn7b' onClick='_gaq.push([\"_trackEvent\",  \"Switcheroo\", \"FinalSwitch\", \"Girl\"]);'>Go back to your room and leave the chair where it is.</a></li></ul"
);

undum.game.situations['switchreturn7a'] = new undum.SimpleSituation(
	"<p>Denise went to the curb to retrieve <a href='switchreturn7'>the wheel chair.</a></p>"
);

undum.game.situations['switchreturn7b'] = new undum.SimpleSituation(
	"<p>Denise went back to her room and left the wheel chair <a href='switchreturn7'>where it was.</a></p>"
);

undum.game.situations['switchreturn7'] = new undum.SimpleSituation(
      "<h1>The End of Switcheroo.</h1>",
	/*  "Huck Finn".l(),  "Tom Sawyer".l(), "Catniss".l(),  "Percy Jackson".l(),  "Mulan".l(), "Harry Potter".l(), "Matilda".l(), "Hermione".l(),   "Dorothy".l(), "Little Prince".l(), "Cinderella".l(), "Sleeping Beauty".l()*/
    { 
   enter: function(character, system, from) {
	        genderlist = ["Huck Finn from <em>The Adventures of Huckleberry Finn</em>", "Tom Sawyer from <em>The Adventures of Tom Sawyer</em>",  "Catniss from <em>The Hunger Games</em>",  "Percy Jackson from <em>The Lightning Thief series</em>", "Mulan", "Harry Potter", "Matilda",  "Hermione from the Harry Potter books",  "Dorothy from <em>The Wizard of Oz</em>", "the Little Prince", "Cinderella", "Sleeping Beauty"]; 
			genderlist2 = [
			// Huck
			"you seem quite at home with who you are and feel little need to follow the rules of the land about wearing shoes or sleeping inside or using forks and knives",
			//Tom Sawyer
			"you seem like you know how to be the good kid when needed, but you dream of playing the pirate",
			//Catniss
			"you seem to be a fierce competitor who will play the game but by your own rules. You are ever ready to put down a foe with one shot, your perfect braid tight as a fist",
			//Percy Jackson
			"you seem like a brave warrior who feels like someone who is living in the wrong era",
			//Mulan
			"you seem like you are torn between playing the role people want you to play and being the person you were meant to be",
			//Harry Potter
			"you seem like someone who can stand up to monsters, like evil wizards and popular kids, but sometimes you also care too much about what they think of you",
			//Matilda
			"you seem like someone who has great powers locked within you to stand up to others when they try to push your friends around, but you are not quite sure how to control those powers",
			//Hermione
			"you seem like someone who cares for others deeply, is ready to stand up to monsters, but also wants Ron to ask you to the ball (why I'll never understand)",
			//Dorothy
			"you seem like someone who is tired of the same old same old, but you're not quite sure what kind of witch you will turn out to be: one who floats around in bubbles, one who worries about shoes, or one who melts the people who hurts her friends",
			//Little Prince
			"you seem like a sweet soul, a tender heart who wants to go home and care for your flower, even if she didn't treat you very well",
			//Cinderella
			"you know you are more than people say you are, but you sometimes need the help of your friends to help you get your glitter on, up from the ashes, and out to the ball",
			//Sleeping Beauty
			"you are so tired of spinning wheels and godmothers who are jealous of you and of princes who never seem to show up when you need them"]
			if (character.qualities.gender+6>=5){
			    character.qualities.gender=5;
			}
	        system.write("<p>Very well. That is all. Now I was forming an impression of you as you were reading, and I'd say you came off most like " + genderlist[character.qualities.gender+6] + ". Based on the way you flipped through my pages and the choices you have made, " +genderlist2[character.qualities.gender+6] + ". But don't let me tell you who you are.  Nobody knows who you are till you live your life and show them.  That's what Mrs. Wobbles says, at least.</p>\
			<p>If you liked this story and would like to hear about future tales from Mrs. Wobbles, <a href='http://newstory.kickoffpages.com'>sign up here.</a> Or perhaps you'd like to <a href='index.html'>read it again.</a></p>");
	},
     exit: function(character, system, to) {
	    $("#content").empty();
		}	
     }
	);
//---- --------------------------------------------------------------------------------------------	
   /* The Id of the starting situation. */
undum.game.start = "start";


// ---------------------------------------------------------------------------
/* Here we define all the qualities that our characters could
 * possess. We don't have to be exhaustive, but if we miss one out then
 * that quality will never show up in the character bar in the UI. */
undum.game.qualities = {
    poetry: new undum.IntegerQuality(
        "Poem Powers", {priority:"0001", group:'stats'}
    ),
    page: new undum.NumericQuality(
        "Page Points", {priority:"0002", group:'stats'}
    ),
/*    luck: new undum.FudgeAdjectivesQuality( // Fudge as in the FUDGE RPG
        "<span title='Poetry Powers, Page Points, and Luck are reverently borrowed from the Fighting Fantasy series of gamebooks. The words representing Luck are from the FUDGE RPG. This tooltip is illustrating that you can use any HTML in the label for a quality (in this case a span containing a title attribute).'>Luck</span>",
        {priority:"0003", group:'stats'}
    ),
    
   inspiration: new undum.NonZeroIntegerQuality(
        "Inspiration", {priority:"0001", group:'progress'}
    ),*/
    gender: new undum.GenderAdjectivesQuality(
	          "You are acting like...", {priority:"0002", group:'stats'}
			  ),
/*
    novice: new undum.OnOffQuality(
        "Novice", {priority:"0002", group:'progress', onDisplay:"&#10003;"}
    ),
	*/
	jetpack: new undum.IntegerQuality(
		"Jetpacks", {priority:"0004", group:'stats'}
	)
};


// ---------------------------------------------------------------------------
/* The qualities are displayed in groups in the character bar. This
 * determines the groups, their heading (which can be null for no
 * heading) and ordering. QualityDefinitions without a group appear at
 * the end. It is an error to have a quality definition belong to a
 * non-existent group. */
undum.game.qualityGroups = {
    stats: new undum.QualityGroup(null, {priority:"0001"}),
    progress: new undum.QualityGroup('Progress', {priority:"0002"})
};

// ---------------------------------------------------------------------------
/* This function gets run before the game begins. It is normally used
 * to configure the character at the start of play. */
undum.game.init = function(character, system) {
    character.qualities.poetry = 6;
    character.qualities.page = 6;
    character.qualities.luck = 0;
    character.qualities.novice = 1;
    character.qualities.inspiration = 0;
    character.sandbox.name = "";
	character.sandbox.outfitmatch = false;
	character.sandbox.outfit = 4;
    character.sandbox.outfitmismatch = 0;
	character.qualities.gender=0;
	character.sandbox.readstory=false;
	character.sandbox.pickoutfit=false;
    system.setCharacterText("<p>What if things got flipped?</p>");
};